/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.CompressionAlgorithm;
import com.nimbusds.jose.DefaultJWEHeaderFilter;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEHeaderFilter;
import com.nimbusds.jose.ReadOnlyJWEHeader;
import com.nimbusds.jose.crypto.AES;
import com.nimbusds.jose.crypto.AESCBC;
import com.nimbusds.jose.crypto.AESGCM;
import com.nimbusds.jose.crypto.ConcatKDF;
import com.nimbusds.jose.crypto.HMAC;
import com.nimbusds.jose.crypto.RSA1_5;
import com.nimbusds.jose.crypto.RSACryptoProvider;
import com.nimbusds.jose.crypto.RSA_OAEP;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.DeflateUtils;
import java.io.UnsupportedEncodingException;
import java.security.interfaces.RSAPrivateKey;
import javax.crypto.SecretKey;
import org.bouncycastle.util.Arrays;

public class RSADecrypter
extends RSACryptoProvider
implements JWEDecrypter {
    private final DefaultJWEHeaderFilter headerFilter;
    private RSAPrivateKey privateKey;

    public RSADecrypter(RSAPrivateKey privateKey) {
        if (privateKey == null) {
            throw new IllegalArgumentException("The private RSA key must not be null");
        }
        this.privateKey = privateKey;
        this.headerFilter = new DefaultJWEHeaderFilter(this.supportedAlgorithms(), this.supportedEncryptionMethods());
    }

    public RSAPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public JWEHeaderFilter getJWEHeaderFilter() {
        return this.headerFilter;
    }

    private static final byte[] applyDecompression(ReadOnlyJWEHeader readOnlyJWEHeader, byte[] bytes) throws JOSEException {
        CompressionAlgorithm compressionAlg = readOnlyJWEHeader.getCompressionAlgorithm();
        if (compressionAlg == null) {
            return bytes;
        }
        if (compressionAlg.equals(CompressionAlgorithm.DEF)) {
            try {
                return DeflateUtils.decompress(bytes);
            }
            catch (Exception e) {
                throw new JOSEException("Couldn't decompress plain text: " + e.getMessage(), e);
            }
        }
        throw new JOSEException("Unsupported compression algorithm: " + compressionAlg);
    }

    public byte[] decrypt(ReadOnlyJWEHeader readOnlyJWEHeader, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL integrityValue) throws JOSEException {
        byte[] plainText;
        if (encryptedKey == null) {
            throw new JOSEException("The encrypted key must not be null");
        }
        if (iv == null) {
            throw new JOSEException("The initialization vector (IV) must not be null");
        }
        if (integrityValue == null) {
            throw new JOSEException("The integrity value must not be null");
        }
        JWEAlgorithm alg = readOnlyJWEHeader.getAlgorithm();
        SecretKey cmk = null;
        if (alg.equals(JWEAlgorithm.RSA1_5)) {
            int keyLength = RSADecrypter.cmkBitLength(readOnlyJWEHeader.getEncryptionMethod());
            SecretKey randomCMK = AES.generateAESCMK(keyLength);
            try {
                cmk = RSA1_5.decryptCMK(this.privateKey, encryptedKey.decode(), keyLength);
            }
            catch (Exception e) {
                cmk = randomCMK;
            }
        } else if (alg.equals(JWEAlgorithm.RSA_OAEP)) {
            cmk = RSA_OAEP.decryptCMK(this.privateKey, encryptedKey.decode());
        } else {
            throw new JOSEException("Unsupported algorithm, must be RSA1_5 or RSA_OAEP");
        }
        EncryptionMethod enc = readOnlyJWEHeader.getEncryptionMethod();
        if (enc.equals(EncryptionMethod.A128CBC_HS256) || enc.equals(EncryptionMethod.A256CBC_HS512)) {
            byte[] epu = null;
            if (readOnlyJWEHeader.getEncryptionPartyUInfo() != null) {
                epu = readOnlyJWEHeader.getEncryptionPartyUInfo().decode();
            }
            byte[] epv = null;
            if (readOnlyJWEHeader.getEncryptionPartyVInfo() != null) {
                epv = readOnlyJWEHeader.getEncryptionPartyVInfo().decode();
            }
            SecretKey cek = ConcatKDF.generateCEK(cmk, enc, epu, epv);
            plainText = AESCBC.decrypt(cek, iv.decode(), cipherText.decode());
            SecretKey cik = ConcatKDF.generateCIK(cmk, enc, epu, epv);
            String macInput = readOnlyJWEHeader.toBase64URL().toString() + "." + encryptedKey.toString() + "." + iv.toString() + "." + cipherText.toString();
            byte[] mac = HMAC.compute(cik, macInput.getBytes());
            if (!Arrays.constantTimeAreEqual(integrityValue.decode(), mac)) {
                throw new JOSEException("HMAC integrity check failed");
            }
        } else if (enc.equals(EncryptionMethod.A128GCM) || enc.equals(EncryptionMethod.A256GCM)) {
            String authDataString = readOnlyJWEHeader.toBase64URL().toString() + "." + encryptedKey.toString() + "." + iv.toString();
            byte[] authData = null;
            try {
                authData = authDataString.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new JOSEException(e.getMessage(), e);
            }
            plainText = AESGCM.decrypt(cmk, iv.decode(), cipherText.decode(), authData, integrityValue.decode());
        } else {
            throw new JOSEException("Unsupported encryption method, must be A128CBC_HS256, A256CBC_HS512, A128GCM or A128GCM");
        }
        return RSADecrypter.applyDecompression(readOnlyJWEHeader, plainText);
    }
}

