/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.entity;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaPageResults<T> {
    private static final Logger logger = LoggerFactory.getLogger(JpaPageResults.class);
    private int page = 0;
    private int total = 0;
    private int totalPage = 0;
    private Long records = 0L;
    private List<T> rows;

    public JpaPageResults() {
        logger.debug("JpaPageResults.");
    }

    public JpaPageResults(int currentPage, int pageResults, Long recordsCount) {
        this.pageCount(currentPage, pageResults, recordsCount);
        logger.debug("JpaPageResults : {} , records : {} , totalPage : {}", new Object[]{this.page, this.records, this.totalPage});
    }

    public JpaPageResults(int currentPage, int pageResults, Long recordsCount, List<T> rows) {
        this.pageCount(currentPage, pageResults, recordsCount);
        this.rows = rows;
    }

    public JpaPageResults(int currentPage, int pageResults, Integer recordsCount, List<T> rows) {
        this.pageCount(currentPage, pageResults, recordsCount);
        this.rows = rows;
    }

    public JpaPageResults(int currentPage, int pageResults, int totalPage, Long recordsCount, List<T> rows) {
        this.pageCount(currentPage, pageResults, recordsCount);
        this.rows = rows;
        this.total = totalPage;
    }

    public JpaPageResults(int currentPage, int pageResults, int totalPage, Integer recordsCount, List<T> rows) {
        this.pageCount(currentPage, pageResults, recordsCount);
        this.rows = rows;
        this.total = totalPage;
    }

    public void pageCount(int currentPage, int pageResults, Long recordsCount) {
        this.page = currentPage;
        this.totalPage = (int)(recordsCount % (long)pageResults > 0L ? recordsCount / (long)pageResults + 1L : recordsCount / (long)pageResults);
        this.records = recordsCount;
    }

    public void pageCount(int currentPage, int pageResults, Integer recordsCount) {
        this.page = currentPage;
        this.totalPage = recordsCount % pageResults > 0 ? recordsCount / pageResults + 1 : recordsCount / pageResults;
        this.records = (long)recordsCount;
    }

    public static Integer parseCount(Object totalCount) {
        Integer retTotalCount = 0;
        if (totalCount == null) {
            return retTotalCount;
        }
        retTotalCount = Integer.parseInt(totalCount.toString());
        return retTotalCount;
    }

    public static Integer parseRecords(List<?> resultslist) {
        return CollectionUtils.isEmpty(resultslist) ? 0 : resultslist.size();
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public Long getRecords() {
        return this.records;
    }

    public void setRecords(Long records) {
        this.records = records;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JpaPageResults [page=");
        builder.append(this.page);
        builder.append(", total=");
        builder.append(this.total);
        builder.append(", totalPage=");
        builder.append(this.totalPage);
        builder.append(", records=");
        builder.append(this.records);
        builder.append(", rows=");
        builder.append(this.rows);
        builder.append("]");
        return builder.toString();
    }
}

