/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.dictionary;

import edu.vt.middleware.dictionary.WordList;
import java.util.Comparator;
import java.util.Iterator;

public abstract class AbstractWordList
implements WordList {
    protected Comparator<String> comparator;

    @Override
    public Comparator<String> getComparator() {
        return this.comparator;
    }

    @Override
    public Iterator<String> iterator() {
        return new SequentialIterator();
    }

    @Override
    public Iterator<String> medianIterator() {
        return new MedianIterator();
    }

    protected void checkRange(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Supplied index (" + index + ") does not exist");
        }
    }

    protected void checkIsString(Object o) {
        if (!String.class.isInstance(o)) {
            throw new ClassCastException("Parameter must be of type String");
        }
    }

    private class MedianIterator
    extends AbstractWordListIterator {
        private final int median;
        private int sign;

        private MedianIterator() {
            this.median = AbstractWordList.this.size() / 2;
        }

        @Override
        public boolean hasNext() {
            int n = AbstractWordList.this.size();
            boolean result = this.sign > 0 ? this.median + this.index < n : (this.sign < 0 ? this.median - this.index >= 0 : n > 0);
            return result;
        }

        @Override
        public String next() {
            String next;
            if (this.sign > 0) {
                next = AbstractWordList.this.get(this.median + this.index);
                this.sign = -1;
                ++this.index;
            } else if (this.sign < 0) {
                next = AbstractWordList.this.get(this.median - this.index);
                this.sign = 1;
            } else {
                next = AbstractWordList.this.get(this.median);
                this.sign = -1;
                this.index = 1;
            }
            return next;
        }
    }

    private class SequentialIterator
    extends AbstractWordListIterator {
        private SequentialIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < AbstractWordList.this.size();
        }

        @Override
        public String next() {
            return AbstractWordList.this.get(this.index++);
        }
    }

    private abstract class AbstractWordListIterator
    implements Iterator<String> {
        protected int index;

        private AbstractWordListIterator() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported.");
        }
    }
}

