/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.x509.types;

import java.util.Arrays;

public class NoticeReference {
    private static final int HASH_FACTOR = 31;
    private String organization;
    private int[] noticeNumbers;

    public NoticeReference(String org, int[] numbers) {
        if (org == null || "".equals(org)) {
            throw new IllegalArgumentException("Organization cannot be null or empty string.");
        }
        this.organization = org;
        if (numbers == null || numbers.length == 0) {
            throw new IllegalArgumentException("Notice numbers cannot be null and must contain at least one element.");
        }
        this.noticeNumbers = numbers;
    }

    public String getOrganization() {
        return this.organization;
    }

    public int[] getNoticeNumbers() {
        return this.noticeNumbers;
    }

    public String toString() {
        return String.format("(%s, %s)", this.organization, Arrays.toString(this.noticeNumbers));
    }

    public boolean equals(Object obj) {
        NoticeReference other;
        boolean result = false;
        result = obj == this ? true : (obj == null || obj.getClass() != this.getClass() ? false : (other = (NoticeReference)obj).getOrganization().equals(this.organization) && Arrays.equals(other.getNoticeNumbers(), this.noticeNumbers));
        return result;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = 31 * hash + this.organization.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.noticeNumbers);
        return hash;
    }
}

