/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.mac;

import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.Mac;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.subtle.Bytes;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

public final class MacFactory {
    private static final Logger logger = Logger.getLogger(MacFactory.class.getName());

    public static Mac getPrimitive(KeysetHandle keysetHandle) throws GeneralSecurityException {
        return MacFactory.getPrimitive(keysetHandle, null);
    }

    public static Mac getPrimitive(KeysetHandle keysetHandle, KeyManager<Mac> keyManager) throws GeneralSecurityException {
        final PrimitiveSet<Mac> primitives = Registry.getPrimitives(keysetHandle, keyManager);
        MacFactory.validate(primitives);
        final byte[] formatVersion = new byte[]{0};
        return new Mac(){

            @Override
            public byte[] computeMac(byte[] data) throws GeneralSecurityException {
                if (primitives.getPrimary().getOutputPrefixType().equals((Object)OutputPrefixType.LEGACY)) {
                    return Bytes.concat(primitives.getPrimary().getIdentifier(), ((Mac)primitives.getPrimary().getPrimitive()).computeMac(Bytes.concat(data, formatVersion)));
                }
                return Bytes.concat(primitives.getPrimary().getIdentifier(), ((Mac)primitives.getPrimary().getPrimitive()).computeMac(data));
            }

            @Override
            public void verifyMac(byte[] mac, byte[] data) throws GeneralSecurityException {
                if (mac.length <= 5) {
                    throw new GeneralSecurityException("tag too short");
                }
                byte[] prefix = Arrays.copyOfRange(mac, 0, 5);
                byte[] macNoPrefix = Arrays.copyOfRange(mac, 5, mac.length);
                List entries = primitives.getPrimitive(prefix);
                for (PrimitiveSet.Entry entry : entries) {
                    try {
                        if (entry.getOutputPrefixType().equals((Object)OutputPrefixType.LEGACY)) {
                            ((Mac)entry.getPrimitive()).verifyMac(macNoPrefix, Bytes.concat(data, formatVersion));
                        } else {
                            ((Mac)entry.getPrimitive()).verifyMac(macNoPrefix, data);
                        }
                        return;
                    }
                    catch (GeneralSecurityException e) {
                        logger.info("tag prefix matches a key, but cannot verify: " + e.toString());
                    }
                }
                entries = primitives.getRawPrimitives();
                for (PrimitiveSet.Entry entry : entries) {
                    try {
                        ((Mac)entry.getPrimitive()).verifyMac(mac, data);
                        return;
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                    }
                }
                throw new GeneralSecurityException("invalid MAC");
            }
        };
    }

    private static void validate(PrimitiveSet<Mac> pset) throws GeneralSecurityException {
        for (Collection collection : pset.getAll()) {
            for (PrimitiveSet.Entry entry : collection) {
                if (entry.getPrimitive() instanceof Mac) continue;
                throw new GeneralSecurityException("invalid MAC key material");
            }
        }
    }
}

