/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid;

import com.google.crypto.tink.HybridEncrypt;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.subtle.Bytes;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.logging.Logger;

public final class HybridEncryptFactory {
    private static final Logger logger = Logger.getLogger(HybridEncryptFactory.class.getName());

    public static HybridEncrypt getPrimitive(KeysetHandle keysetHandle) throws GeneralSecurityException {
        return HybridEncryptFactory.getPrimitive(keysetHandle, null);
    }

    public static HybridEncrypt getPrimitive(KeysetHandle keysetHandle, KeyManager<HybridEncrypt> keyManager) throws GeneralSecurityException {
        final PrimitiveSet<HybridEncrypt> primitives = Registry.getPrimitives(keysetHandle, keyManager);
        HybridEncryptFactory.validate(primitives);
        return new HybridEncrypt(){

            @Override
            public byte[] encrypt(byte[] plaintext, byte[] contextInfo) throws GeneralSecurityException {
                return Bytes.concat(primitives.getPrimary().getIdentifier(), ((HybridEncrypt)primitives.getPrimary().getPrimitive()).encrypt(plaintext, contextInfo));
            }
        };
    }

    private static void validate(PrimitiveSet<HybridEncrypt> pset) throws GeneralSecurityException {
        for (Collection collection : pset.getAll()) {
            for (PrimitiveSet.Entry entry : collection) {
                if (entry.getPrimitive() instanceof HybridEncrypt) continue;
                throw new GeneralSecurityException("invalid HybridEncrypt key material");
            }
        }
    }
}

