/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid;

import com.google.crypto.tink.HybridDecrypt;
import com.google.crypto.tink.PrivateKeyManager;
import com.google.crypto.tink.hybrid.HybridUtil;
import com.google.crypto.tink.hybrid.RegistryEciesAeadHkdfDemHelper;
import com.google.crypto.tink.proto.EciesAeadHkdfKeyFormat;
import com.google.crypto.tink.proto.EciesAeadHkdfParams;
import com.google.crypto.tink.proto.EciesAeadHkdfPrivateKey;
import com.google.crypto.tink.proto.EciesAeadHkdfPublicKey;
import com.google.crypto.tink.proto.EciesHkdfKemParams;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.EciesAeadHkdfHybridDecrypt;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;

class EciesAeadHkdfPrivateKeyManager
implements PrivateKeyManager<HybridDecrypt> {
    private static final int VERSION = 0;
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.EciesAeadHkdfPrivateKey";

    EciesAeadHkdfPrivateKeyManager() {
    }

    @Override
    public HybridDecrypt getPrimitive(ByteString serializedKey) throws GeneralSecurityException {
        try {
            EciesAeadHkdfPrivateKey recipientKeyProto = EciesAeadHkdfPrivateKey.parseFrom(serializedKey);
            return this.getPrimitive((MessageLite)recipientKeyProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized EciesAeadHkdfPrivateKey proto", e);
        }
    }

    @Override
    public HybridDecrypt getPrimitive(MessageLite recipientKey) throws GeneralSecurityException {
        if (!(recipientKey instanceof EciesAeadHkdfPrivateKey)) {
            throw new GeneralSecurityException("expected EciesAeadHkdfPrivateKey proto");
        }
        EciesAeadHkdfPrivateKey recipientKeyProto = (EciesAeadHkdfPrivateKey)recipientKey;
        this.validate(recipientKeyProto);
        EciesAeadHkdfParams eciesParams = recipientKeyProto.getPublicKey().getParams();
        EciesHkdfKemParams kemParams = eciesParams.getKemParams();
        ECPrivateKey recipientPrivateKey = EllipticCurves.getEcPrivateKey(HybridUtil.toCurveType(kemParams.getCurveType()), recipientKeyProto.getKeyValue().toByteArray());
        RegistryEciesAeadHkdfDemHelper demHelper = new RegistryEciesAeadHkdfDemHelper(eciesParams.getDemParams().getAeadDem());
        return new EciesAeadHkdfHybridDecrypt(recipientPrivateKey, kemParams.getHkdfSalt().toByteArray(), HybridUtil.toHmacAlgo(kemParams.getHkdfHashType()), HybridUtil.toPointFormatType(eciesParams.getEcPointFormat()), demHelper);
    }

    @Override
    public MessageLite newKey(ByteString serializedKeyFormat) throws GeneralSecurityException {
        try {
            EciesAeadHkdfKeyFormat eciesKeyFormat = EciesAeadHkdfKeyFormat.parseFrom(serializedKeyFormat);
            return this.newKey((MessageLite)eciesKeyFormat);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("invalid EciesAeadHkdf key format", e);
        }
    }

    @Override
    public MessageLite newKey(MessageLite keyFormat) throws GeneralSecurityException {
        if (!(keyFormat instanceof EciesAeadHkdfKeyFormat)) {
            throw new GeneralSecurityException("expected EciesAeadHkdfKeyFormat proto");
        }
        EciesAeadHkdfKeyFormat eciesKeyFormat = (EciesAeadHkdfKeyFormat)keyFormat;
        HybridUtil.validate(eciesKeyFormat.getParams());
        EciesHkdfKemParams kemParams = eciesKeyFormat.getParams().getKemParams();
        KeyPair keyPair = EllipticCurves.generateKeyPair(HybridUtil.toCurveType(kemParams.getCurveType()));
        ECPublicKey pubKey = (ECPublicKey)keyPair.getPublic();
        ECPrivateKey privKey = (ECPrivateKey)keyPair.getPrivate();
        ECPoint w = pubKey.getW();
        EciesAeadHkdfPublicKey eciesPublicKey = EciesAeadHkdfPublicKey.newBuilder().setVersion(0).setParams(eciesKeyFormat.getParams()).setX(ByteString.copyFrom((byte[])w.getAffineX().toByteArray())).setY(ByteString.copyFrom((byte[])w.getAffineY().toByteArray())).build();
        return EciesAeadHkdfPrivateKey.newBuilder().setVersion(0).setPublicKey(eciesPublicKey).setKeyValue(ByteString.copyFrom((byte[])privKey.getS().toByteArray())).build();
    }

    @Override
    public KeyData newKeyData(ByteString serializedKeyFormat) throws GeneralSecurityException {
        EciesAeadHkdfPrivateKey key = (EciesAeadHkdfPrivateKey)this.newKey(serializedKeyFormat);
        return KeyData.newBuilder().setTypeUrl(TYPE_URL).setValue(key.toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.ASYMMETRIC_PRIVATE).build();
    }

    @Override
    public KeyData getPublicKeyData(ByteString serializedKey) throws GeneralSecurityException {
        try {
            EciesAeadHkdfPrivateKey privKeyProto = EciesAeadHkdfPrivateKey.parseFrom(serializedKey);
            return KeyData.newBuilder().setTypeUrl("type.googleapis.com/google.crypto.tink.EciesAeadHkdfPublicKey").setValue(privKeyProto.getPublicKey().toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC).build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized EciesAeadHkdfPrivateKey proto", e);
        }
    }

    @Override
    public boolean doesSupport(String typeUrl) {
        return TYPE_URL.equals(typeUrl);
    }

    @Override
    public String getKeyType() {
        return TYPE_URL;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private void validate(EciesAeadHkdfPrivateKey keyProto) throws GeneralSecurityException {
        Validators.validateVersion(keyProto.getVersion(), 0);
        HybridUtil.validate(keyProto.getPublicKey().getParams());
    }
}

