/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.KmsClients;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KmsAeadKey;
import com.google.crypto.tink.proto.KmsAeadKeyFormat;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;

class KmsAeadKeyManager
implements KeyManager<Aead> {
    private static final int VERSION = 0;
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.KmsAeadKey";

    KmsAeadKeyManager() {
    }

    @Override
    public Aead getPrimitive(ByteString serializedKey) throws GeneralSecurityException {
        try {
            KmsAeadKey keyProto = KmsAeadKey.parseFrom(serializedKey);
            return this.getPrimitive((MessageLite)keyProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected KmsAeadKey proto", e);
        }
    }

    @Override
    public Aead getPrimitive(MessageLite key) throws GeneralSecurityException {
        if (!(key instanceof KmsAeadKey)) {
            throw new GeneralSecurityException("expected KmsAeadKey proto");
        }
        KmsAeadKey keyProto = (KmsAeadKey)key;
        KmsAeadKeyManager.validate(keyProto);
        String keyUri = keyProto.getParams().getKeyUri();
        KmsClient kmsClient = KmsClients.get(keyUri);
        return kmsClient.getAead(keyUri);
    }

    @Override
    public MessageLite newKey(ByteString serializedKeyFormat) throws GeneralSecurityException {
        try {
            KmsAeadKeyFormat format = KmsAeadKeyFormat.parseFrom(serializedKeyFormat);
            return this.newKey((MessageLite)format);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("expected serialized KmsAeadKeyFormat proto", e);
        }
    }

    @Override
    public MessageLite newKey(MessageLite keyFormat) throws GeneralSecurityException {
        if (!(keyFormat instanceof KmsAeadKeyFormat)) {
            throw new GeneralSecurityException("expected KmsAeadKeyFormat proto");
        }
        KmsAeadKeyFormat format = (KmsAeadKeyFormat)keyFormat;
        return KmsAeadKey.newBuilder().setParams(format).setVersion(0).build();
    }

    @Override
    public KeyData newKeyData(ByteString serializedKeyFormat) throws GeneralSecurityException {
        KmsAeadKey key = (KmsAeadKey)this.newKey(serializedKeyFormat);
        return KeyData.newBuilder().setTypeUrl(TYPE_URL).setValue(key.toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.REMOTE).build();
    }

    @Override
    public boolean doesSupport(String typeUrl) {
        return typeUrl.equals(TYPE_URL);
    }

    @Override
    public String getKeyType() {
        return TYPE_URL;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private static void validate(KmsAeadKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), 0);
    }
}

