/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.proto.ChaCha20Poly1305Key;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.ChaCha20Poly1305;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;

class ChaCha20Poly1305KeyManager
implements KeyManager<Aead> {
    public static final String TYPE_URL = "type.googleapis.com/google.crypto.tink.ChaCha20Poly1305Key";
    private static final int KEY_SIZE_IN_BYTES = 32;
    private static final int VERSION = 0;

    ChaCha20Poly1305KeyManager() {
    }

    @Override
    public Aead getPrimitive(ByteString serialized) throws GeneralSecurityException {
        try {
            ChaCha20Poly1305Key keyProto = ChaCha20Poly1305Key.parseFrom(serialized);
            return this.getPrimitive((MessageLite)keyProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("invalid ChaCha20Poly1305 key", e);
        }
    }

    @Override
    public Aead getPrimitive(MessageLite key) throws GeneralSecurityException {
        if (!(key instanceof ChaCha20Poly1305Key)) {
            throw new GeneralSecurityException("expected ChaCha20Poly1305Key proto");
        }
        ChaCha20Poly1305Key keyProto = (ChaCha20Poly1305Key)key;
        this.validate(keyProto);
        return new ChaCha20Poly1305(keyProto.getKeyValue().toByteArray());
    }

    @Override
    public MessageLite newKey(ByteString unused) throws GeneralSecurityException {
        return this.newKey();
    }

    @Override
    public MessageLite newKey(MessageLite unused) throws GeneralSecurityException {
        return this.newKey();
    }

    @Override
    public KeyData newKeyData(ByteString unused) throws GeneralSecurityException {
        ChaCha20Poly1305Key key = this.newKey();
        return KeyData.newBuilder().setTypeUrl(TYPE_URL).setValue(key.toByteString()).setKeyMaterialType(KeyData.KeyMaterialType.SYMMETRIC).build();
    }

    @Override
    public boolean doesSupport(String typeUrl) {
        return TYPE_URL.equals(typeUrl);
    }

    @Override
    public String getKeyType() {
        return TYPE_URL;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private ChaCha20Poly1305Key newKey() throws GeneralSecurityException {
        return ChaCha20Poly1305Key.newBuilder().setVersion(0).setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(32))).build();
    }

    private void validate(ChaCha20Poly1305Key keyProto) throws GeneralSecurityException {
        Validators.validateVersion(keyProto.getVersion(), 0);
        if (keyProto.getKeyValue().size() != 32) {
            throw new GeneralSecurityException("invalid ChaCha20Poly1305Key: incorrect key length");
        }
    }
}

