/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Signal;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class FluxSwitchOnFirst<T, R>
extends FluxOperator<T, R> {
    static final int STATE_INIT = 0;
    static final int STATE_SUBSCRIBED_ONCE = 1;
    static final int STATE_REQUESTED_ONCE = 2;
    final BiFunction<Signal<? extends T>, Flux<T>, Publisher<? extends R>> transformer;

    FluxSwitchOnFirst(Flux<? extends T> source, BiFunction<Signal<? extends T>, Flux<T>, Publisher<? extends R>> transformer) {
        super(source);
        this.transformer = Objects.requireNonNull(transformer, "transformer");
    }

    @Override
    public int getPrefetch() {
        return 1;
    }

    @Override
    public void subscribe(CoreSubscriber<? super R> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            this.source.subscribe(new SwitchOnFirstConditionalInner<T, R>((Fuseable.ConditionalSubscriber)actual, this.transformer));
            return;
        }
        this.source.subscribe(new SwitchOnFirstInner<T, R>(actual, this.transformer));
    }

    static final class SwitchOnFirstConditionalInnerSubscriber<T>
    implements InnerConsumer<T>,
    Fuseable.ConditionalSubscriber<T> {
        final AbstractSwitchOnFirstInner<?, ? super T> parent;
        final Fuseable.ConditionalSubscriber<? super T> inner;

        SwitchOnFirstConditionalInnerSubscriber(AbstractSwitchOnFirstInner<?, ? super T> parent, Fuseable.ConditionalSubscriber<? super T> inner) {
            this.parent = parent;
            this.inner = inner;
        }

        @Override
        public Context currentContext() {
            return this.inner.currentContext();
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.inner.onSubscribe(s);
        }

        public void onNext(T t) {
            this.inner.onNext(t);
        }

        @Override
        public boolean tryOnNext(T t) {
            return this.inner.tryOnNext(t);
        }

        public void onError(Throwable throwable) {
            if (!this.parent.done) {
                this.parent.cancel();
            }
            this.inner.onError(throwable);
        }

        public void onComplete() {
            if (!this.parent.done) {
                this.parent.cancel();
            }
            this.inner.onComplete();
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.parent;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.inner;
            }
            return null;
        }
    }

    static final class SwitchOnFirstInnerSubscriber<T>
    implements InnerConsumer<T> {
        final AbstractSwitchOnFirstInner<?, T> parent;
        final CoreSubscriber<? super T> inner;

        SwitchOnFirstInnerSubscriber(AbstractSwitchOnFirstInner<?, T> parent, CoreSubscriber<? super T> inner) {
            this.parent = parent;
            this.inner = inner;
        }

        @Override
        public Context currentContext() {
            return this.inner.currentContext();
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.inner.onSubscribe(s);
        }

        public void onNext(T t) {
            this.inner.onNext(t);
        }

        public void onError(Throwable throwable) {
            if (!this.parent.done) {
                this.parent.cancel();
            }
            this.inner.onError(throwable);
        }

        public void onComplete() {
            if (!this.parent.done) {
                this.parent.cancel();
            }
            this.inner.onComplete();
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.parent;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.inner;
            }
            return null;
        }
    }

    static final class SwitchOnFirstConditionalInner<T, R>
    extends AbstractSwitchOnFirstInner<T, R>
    implements Fuseable.ConditionalSubscriber<T> {
        SwitchOnFirstConditionalInner(Fuseable.ConditionalSubscriber<? super R> outer, BiFunction<Signal<? extends T>, Flux<T>, Publisher<? extends R>> transformer) {
            super(outer, transformer);
        }

        @Override
        public void subscribe(CoreSubscriber<? super T> actual) {
            if (this.state == 0 && STATE.compareAndSet(this, 0, 1)) {
                if (this.first == null && this.done) {
                    if (this.throwable != null) {
                        Operators.error(actual, this.throwable);
                    } else {
                        Operators.complete(actual);
                    }
                    return;
                }
                INNER.lazySet(this, Operators.toConditionalSubscriber(actual));
                actual.onSubscribe(this);
            } else {
                Operators.error(actual, new IllegalStateException("FluxSwitchOnFirst allows only one Subscriber"));
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.currentContext());
                return false;
            }
            Fuseable.ConditionalSubscriber i = (Fuseable.ConditionalSubscriber)this.inner;
            if (i == null) {
                Publisher result;
                CoreSubscriber o = this.outer;
                try {
                    result = (Publisher)Objects.requireNonNull(this.transformer.apply(Signal.next(t, o.currentContext()), this), "The transformer returned a null value");
                }
                catch (Throwable e) {
                    this.done = true;
                    Operators.error(o, Operators.onOperatorError(this.s, e, t, o.currentContext()));
                    return false;
                }
                this.first = t;
                result.subscribe((Subscriber)o);
                return true;
            }
            return i.tryOnNext(t);
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                if (this.state == 1 && STATE.compareAndSet(this, 1, 2)) {
                    boolean sent = false;
                    if (this.first != null) {
                        sent = this.drainRegular();
                    }
                    if (sent && n != Long.MAX_VALUE) {
                        if (--n > 0L) {
                            this.s.request(n);
                            return;
                        }
                        return;
                    }
                }
                this.s.request(n);
            }
        }

        @Override
        void drain() {
            this.drainRegular();
        }

        boolean drainRegular() {
            if (WIP.getAndIncrement(this) != 0) {
                return false;
            }
            Object f = this.first;
            int m = 1;
            boolean sent = false;
            Fuseable.ConditionalSubscriber a = (Fuseable.ConditionalSubscriber)this.inner;
            do {
                if (f != null) {
                    this.first = null;
                    if (this.cancelled) {
                        Operators.onDiscard(f, a.currentContext());
                        return false;
                    }
                    sent = a.tryOnNext(f);
                    f = null;
                }
                if (this.cancelled) {
                    return false;
                }
                if (!this.done) continue;
                Throwable t = this.throwable;
                if (t != null) {
                    a.onError(t);
                } else {
                    a.onComplete();
                }
                return sent;
            } while ((m = WIP.addAndGet(this, -m)) != 0);
            return sent;
        }
    }

    static final class SwitchOnFirstInner<T, R>
    extends AbstractSwitchOnFirstInner<T, R> {
        SwitchOnFirstInner(CoreSubscriber<? super R> outer, BiFunction<Signal<? extends T>, Flux<T>, Publisher<? extends R>> transformer) {
            super(outer, transformer);
        }

        @Override
        public void subscribe(CoreSubscriber<? super T> actual) {
            if (this.state == 0 && STATE.compareAndSet(this, 0, 1)) {
                if (this.first == null && this.done) {
                    if (this.throwable != null) {
                        Operators.error(actual, this.throwable);
                    } else {
                        Operators.complete(actual);
                    }
                    return;
                }
                INNER.lazySet(this, actual);
                actual.onSubscribe(this);
            } else {
                Operators.error(actual, new IllegalStateException("FluxSwitchOnFirst allows only one Subscriber"));
            }
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                if (this.state == 1 && STATE.compareAndSet(this, 1, 2)) {
                    if (this.first != null) {
                        this.drain();
                    }
                    if (n != Long.MAX_VALUE) {
                        if (--n > 0L) {
                            this.s.request(n);
                            return;
                        }
                        return;
                    }
                }
                this.s.request(n);
            }
        }

        @Override
        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            Object f = this.first;
            int m = 1;
            CoreSubscriber a = this.inner;
            do {
                if (f != null) {
                    this.first = null;
                    if (this.cancelled) {
                        Operators.onDiscard(f, a.currentContext());
                        return;
                    }
                    a.onNext(f);
                    f = null;
                }
                if (this.cancelled) {
                    return;
                }
                if (!this.done) continue;
                Throwable t = this.throwable;
                if (t != null) {
                    a.onError(t);
                } else {
                    a.onComplete();
                }
                return;
            } while ((m = WIP.addAndGet(this, -m)) != 0);
        }
    }

    static abstract class AbstractSwitchOnFirstInner<T, R>
    extends Flux<T>
    implements InnerOperator<T, R> {
        final CoreSubscriber<? super R> outer;
        final BiFunction<Signal<? extends T>, Flux<T>, Publisher<? extends R>> transformer;
        Subscription s;
        Throwable throwable;
        volatile T first;
        volatile boolean done;
        volatile boolean cancelled;
        volatile CoreSubscriber<? super T> inner;
        static final AtomicReferenceFieldUpdater<AbstractSwitchOnFirstInner, CoreSubscriber> INNER = AtomicReferenceFieldUpdater.newUpdater(AbstractSwitchOnFirstInner.class, CoreSubscriber.class, "inner");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<AbstractSwitchOnFirstInner> WIP = AtomicIntegerFieldUpdater.newUpdater(AbstractSwitchOnFirstInner.class, "wip");
        volatile int state;
        static final AtomicIntegerFieldUpdater<AbstractSwitchOnFirstInner> STATE = AtomicIntegerFieldUpdater.newUpdater(AbstractSwitchOnFirstInner.class, "state");

        AbstractSwitchOnFirstInner(CoreSubscriber<? super R> outer, BiFunction<Signal<? extends T>, Flux<T>, Publisher<? extends R>> transformer) {
            this.outer = outer instanceof Fuseable.ConditionalSubscriber ? new SwitchOnFirstConditionalInnerSubscriber(this, (Fuseable.ConditionalSubscriber)outer) : new SwitchOnFirstInnerSubscriber<R>(this, outer);
            this.transformer = transformer;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.CANCELLED) {
                return this.cancelled;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done || this.cancelled;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public CoreSubscriber<? super R> actual() {
            return this.outer;
        }

        @Override
        public Context currentContext() {
            CoreSubscriber<T> actual = this.inner;
            if (actual != null) {
                return actual.currentContext();
            }
            return this.outer.currentContext();
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.cancel();
                if (WIP.getAndIncrement(this) == 0) {
                    INNER.lazySet(this, null);
                    T f = this.first;
                    if (f != null) {
                        this.first = null;
                        Operators.onDiscard(f, this.currentContext());
                    }
                }
            }
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                s.request(1L);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.currentContext());
                return;
            }
            CoreSubscriber<? super T> i = this.inner;
            if (i == null) {
                Publisher<? extends R> result;
                CoreSubscriber<R> o = this.outer;
                try {
                    result = Objects.requireNonNull(this.transformer.apply(Signal.next(t, o.currentContext()), this), "The transformer returned a null value");
                }
                catch (Throwable e) {
                    this.done = true;
                    Operators.error(o, Operators.onOperatorError(this.s, e, t, o.currentContext()));
                    return;
                }
                this.first = t;
                result.subscribe(o);
                return;
            }
            i.onNext(t);
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.currentContext());
                return;
            }
            this.throwable = t;
            this.done = true;
            CoreSubscriber<? super T> i = this.inner;
            T f = this.first;
            if (f == null && i == null && !this.cancelled) {
                Publisher<? extends R> result;
                CoreSubscriber<R> o = this.outer;
                try {
                    result = Objects.requireNonNull(this.transformer.apply(Signal.error(t, o.currentContext()), this), "The transformer returned a null value");
                }
                catch (Throwable e) {
                    this.done = true;
                    Operators.error(o, Operators.onOperatorError(this.s, e, t, o.currentContext()));
                    return;
                }
                result.subscribe(o);
                return;
            }
            if (f == null) {
                this.drain();
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            CoreSubscriber<? super T> i = this.inner;
            T f = this.first;
            if (f == null && i == null && !this.cancelled) {
                Publisher<? extends R> result;
                CoreSubscriber<R> o = this.outer;
                try {
                    result = Objects.requireNonNull(this.transformer.apply(Signal.complete(o.currentContext()), this), "The transformer returned a null value");
                }
                catch (Throwable e) {
                    this.done = true;
                    Operators.error(o, Operators.onOperatorError(this.s, e, null, o.currentContext()));
                    return;
                }
                result.subscribe(o);
                return;
            }
            if (f == null) {
                this.drain();
            }
        }

        abstract void drain();
    }
}

