/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.util;

import gnu.crypto.hash.HashFactory;
import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.mac.IMac;
import gnu.crypto.mac.MacFactory;
import java.util.HashMap;
import net.jradius.log.RadiusLog;

public class MD5 {
    private static ThreadLocalMD5 md5 = new ThreadLocalMD5();
    private static ThreadLocalHMACMD5 hmacmd5 = new ThreadLocalHMACMD5();
    private static ThreadLocalHMACSHA1 hmacsha1 = new ThreadLocalHMACSHA1();

    public static IMessageDigest getMD5() {
        return md5.getMD5();
    }

    public static IMac getHMACMD5() {
        return hmacmd5.getHMACMD5();
    }

    public static IMac getHMACSHA1() {
        return hmacsha1.getHMACSHA1();
    }

    public static byte[] md5(byte[] text) {
        IMessageDigest md = md5.getMD5();
        md.update(text, 0, text.length);
        return md.digest();
    }

    public static byte[] md5(byte[] text1, byte[] text2) {
        IMessageDigest md = md5.getMD5();
        md.update(text1, 0, text1.length);
        md.update(text2, 0, text2.length);
        return md.digest();
    }

    public static byte[] hmac_md5(byte[] text, byte[] key) {
        return MD5.hmac_md5(text, 0, text.length, key);
    }

    public static byte[] hmac_md5(byte[] text, int toff, int tlen, byte[] key) {
        int minKeyLen = 64;
        byte[] digest = new byte[16];
        if (key.length < minKeyLen) {
            byte[] t = new byte[minKeyLen];
            System.arraycopy(key, 0, t, 0, key.length);
            key = t;
        }
        IMac mac = hmacmd5.getHMACMD5();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("gnu.crypto.mac.key.material", key);
        attributes.put("gnu.crypto.mac.truncated.size", new Integer(16));
        try {
            mac.init(attributes);
        }
        catch (Exception e) {
            RadiusLog.warn(e.getMessage(), e);
        }
        mac.update(text, toff, tlen);
        System.arraycopy(mac.digest(), 0, digest, 0, 16);
        return digest;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadLocalHMACSHA1
    extends ThreadLocal<IMac> {
        private ThreadLocalHMACSHA1() {
        }

        @Override
        public IMac initialValue() {
            return MacFactory.getInstance((String)"HMAC-SHA1");
        }

        public IMac getHMACSHA1() {
            IMac md = (IMac)super.get();
            md.reset();
            return md;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadLocalHMACMD5
    extends ThreadLocal<IMac> {
        private ThreadLocalHMACMD5() {
        }

        @Override
        public IMac initialValue() {
            return MacFactory.getInstance((String)"HMAC-MD5");
        }

        public IMac getHMACMD5() {
            IMac md = (IMac)super.get();
            md.reset();
            return md;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadLocalMD5
    extends ThreadLocal<IMessageDigest> {
        private ThreadLocalMD5() {
        }

        @Override
        public IMessageDigest initialValue() {
            return HashFactory.getInstance((String)"MD5");
        }

        public IMessageDigest getMD5() {
            IMessageDigest md = (IMessageDigest)super.get();
            md.reset();
            return md;
        }
    }
}

