/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.session;

import java.io.Serializable;
import java.util.HashMap;
import net.jradius.exception.RadiusException;
import net.jradius.log.JRadiusLogEntry;
import net.jradius.log.RadiusLog;
import net.jradius.server.EventDispatcher;
import net.jradius.server.JRadiusEvent;
import net.jradius.server.JRadiusRequest;
import net.jradius.server.event.SessionExpiredEvent;
import net.jradius.session.JRadiusSession;
import net.jradius.session.SessionFactory;
import net.jradius.session.SessionKeyProvider;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.event.CacheEventListener;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class JRadiusSessionManager
implements InitializingBean,
ApplicationContextAware,
CacheEventListener {
    private static JRadiusSessionManager defaultManager;
    private static HashMap<String, JRadiusSessionManager> managers;
    private HashMap<String, SessionKeyProvider> providers = new HashMap();
    private HashMap<String, SessionFactory> factories = new HashMap();
    private ApplicationContext applicationContext;
    private int minInterimInterval = 300;
    private int maxInactiveInterval = 2100;
    private String cacheName = "jradius-session";
    private String logCacheName = "jradius-log";
    private CacheManager cacheManager;
    private Cache sessionCache;
    private Cache logCache;
    private EventDispatcher eventDispatcher;

    public static JRadiusSessionManager getManager(Object name) {
        JRadiusSessionManager manager = null;
        if (name != null) {
            manager = managers.get(name);
        }
        if (manager == null) {
            if (defaultManager == null) {
                defaultManager = new JRadiusSessionManager();
                try {
                    defaultManager.afterPropertiesSet();
                }
                catch (Exception e) {
                    RadiusLog.error("Error in JRadius Session Manager", e);
                }
            }
            manager = defaultManager;
        }
        return manager;
    }

    public static JRadiusSessionManager setManager(String name, JRadiusSessionManager manager) {
        if (name != null) {
            managers.put(name, manager);
        } else {
            defaultManager = manager;
        }
        return manager;
    }

    public static void shutdownManagers() {
        if (defaultManager != null) {
            defaultManager.shutdown();
        }
        for (JRadiusSessionManager manager : managers.values()) {
            manager.shutdown();
        }
    }

    public JRadiusSessionManager() {
        this.initialize();
    }

    private void initialize() {
        try {
            Class<?> c = Class.forName("net.jradius.session.RadiusSessionKeyProvider");
            this.providers.put(null, (SessionKeyProvider)c.newInstance());
            c = Class.forName("net.jradius.session.RadiusSessionFactory");
            this.factories.put(null, (SessionFactory)c.newInstance());
        }
        catch (Exception e) {
            RadiusLog.error("Could not find extended JRadius classes - not running JRadiusSessionManager", e);
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        if (this.cacheManager != null && this.cacheManager.getStatus() == Status.STATUS_ALIVE) {
            this.cacheManager.shutdown();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if ((this.sessionCache == null || this.logCache == null) && this.cacheManager == null) {
            throw new RuntimeException("cacheManager required");
        }
        if (this.sessionCache == null) {
            this.sessionCache = this.cacheManager.getCache(this.cacheName);
            if (this.sessionCache == null) {
                this.sessionCache = new Cache(this.cacheName, 50000, false, false, (long)this.maxInactiveInterval, (long)this.maxInactiveInterval);
                this.cacheManager.addCache(this.sessionCache);
            }
        }
        if (this.logCache == null) {
            this.logCache = this.cacheManager.getCache(this.logCacheName);
            if (this.logCache == null) {
                this.logCache = new Cache(this.logCacheName, 20000, false, false, (long)this.maxInactiveInterval, (long)this.maxInactiveInterval);
                this.cacheManager.addCache(this.logCache);
            }
        }
        this.sessionCache.getCacheEventNotificationService().registerListener((CacheEventListener)this);
        this.logCache.getCacheEventNotificationService().registerListener((CacheEventListener)this);
    }

    public void setSessionKeyProvider(String name, SessionKeyProvider provider) {
        this.providers.put(name, provider);
    }

    public void setSessionFactory(String name, SessionFactory factory) {
        this.factories.put(name, factory);
    }

    public SessionKeyProvider getSessionKeyProvider(Object name) {
        SessionKeyProvider provider = this.providers.get(name);
        if (provider == null && name != null) {
            provider = this.providers.get(null);
        }
        return provider;
    }

    public SessionFactory getSessionFactory(Object name) {
        SessionFactory factory = this.factories.get(name);
        if (factory == null && name != null) {
            factory = this.factories.get(null);
        }
        return factory;
    }

    public JRadiusSession getSession(JRadiusRequest request) throws RadiusException {
        SessionKeyProvider skp = this.getSessionKeyProvider(request.getSender());
        Serializable key = skp.getAppSessionKey(request);
        JRadiusSession session = null;
        Serializable nkey = null;
        if (key != null) {
            RadiusLog.debug("** Looking for session: " + key);
            session = this.getSession(request, key);
            if (session == null) {
                RadiusLog.error("Broken JRadius-Session-Id implementation for session: " + key);
                key = null;
            }
        }
        if (key == null && (key = skp.getClassKey(request)) != null) {
            RadiusLog.debug("** Looking for session: " + key);
            session = this.getSession(request, key);
            if (session == null) {
                RadiusLog.error("Broken Class implementation for session: " + key);
                key = null;
            } else if (session.getJRadiusKey() != null && !session.getJRadiusKey().equals(session.getSessionKey())) {
                this.rehashSession(session, (Serializable)((Object)session.getJRadiusKey()), key);
            }
        }
        if (key == null) {
            Serializable keys = skp.getRequestSessionKey(request);
            if (keys == null) {
                return null;
            }
            if (keys instanceof Serializable[]) {
                key = ((Serializable[])keys)[0];
                nkey = ((Serializable[])keys)[1];
                RadiusLog.debug("Rehashing session with key " + key + " under new key " + nkey);
            } else {
                key = keys;
            }
            RadiusLog.debug("** Looking for session: " + key);
            session = this.getSession(request, key);
            if (session != null && nkey != null && !nkey.equals(key)) {
                this.rehashSession(session, key, nkey);
            }
        }
        if (session == null) {
            session = this.newSession(request, nkey == null ? key : nkey);
        }
        session.setTimeStamp(System.currentTimeMillis());
        session.setLastRadiusRequest(request);
        return session;
    }

    public void rehashSession(JRadiusSession session, Serializable okey, Serializable nkey) throws RadiusException {
        this.remove(okey);
        session.setJRadiusKey((String)((Object)nkey));
        this.put(session.getJRadiusKey(), session);
    }

    public JRadiusSession newSession(JRadiusRequest request, Object key) throws RadiusException {
        JRadiusSession session = this.getSessionFactory(request.getSender()).newSession(request);
        session.setJRadiusKey((String)key);
        this.put(session.getJRadiusKey(), session);
        this.put(session.getSessionKey(), session);
        return session;
    }

    public JRadiusSession getSession(JRadiusRequest request, Serializable key) throws RadiusException {
        SessionFactory sf;
        Element element = this.sessionCache.get(key);
        JRadiusSession session = null;
        if (element != null) {
            session = (JRadiusSession)element.getValue();
        }
        if (session == null && request != null && (session = (sf = this.getSessionFactory(request.getSender())).getSession(request, key)) != null) {
            this.put(session.getJRadiusKey(), session);
            this.put(session.getSessionKey(), session);
        }
        if (session == null) {
            return null;
        }
        return session;
    }

    public void lock(JRadiusSession session) {
        session.lock();
    }

    public void unlock(JRadiusSession session, boolean save) {
        session.unlock();
    }

    public JRadiusLogEntry newLogEntry(JRadiusEvent event, JRadiusSession session, String packetId) {
        Object sender = null;
        if (event != null) {
            sender = event.getSender();
        } else if (session != null && session.getLastRadiusRequest() != null) {
            sender = session.getLastRadiusRequest().getSender();
        }
        return this.getSessionFactory(sender).newSessionLogEntry(event, session, packetId);
    }

    public void removeSession(JRadiusSession session) {
        if (session != null) {
            this.remove((Serializable)((Object)session.getJRadiusKey()));
            this.remove((Serializable)((Object)session.getSessionKey()));
        }
    }

    private void remove(Serializable key) {
        RadiusLog.debug("Removing session key: " + key);
        this.sessionCache.remove(key);
    }

    private void put(Object key, Object value) {
        RadiusLog.debug("Adding session key: " + key);
        this.sessionCache.put(new Element(key, value));
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public int getMinInterimInterval() {
        return this.minInterimInterval;
    }

    public void setMinInterimInterval(int minInterimInterval) {
        this.minInterimInterval = minInterimInterval;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void dispose() {
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        Serializable value = element.getValue();
        if (value instanceof JRadiusSession) {
            JRadiusSession session = (JRadiusSession)value;
            RadiusLog.debug("Expired session: " + session.getSessionKey());
            if (this.eventDispatcher != null) {
                SessionExpiredEvent evt = new SessionExpiredEvent(session);
                evt.setApplicationContext(this.applicationContext);
                this.eventDispatcher.post(evt);
            }
        }
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
    }

    public void notifyRemoveAll(Ehcache cache) {
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Ehcache getSessionCache() {
        return this.sessionCache;
    }

    public void setSessionCache(Cache sessionCache) {
        this.sessionCache = sessionCache;
    }

    public void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    static {
        managers = new HashMap();
    }
}

