/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.freeradius;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.jradius.log.RadiusLog;

public class RadiusDictionary {
    private static final String ppkg = "net.jradius.packet.attribute";
    private boolean haveSeenJRadius = false;
    private final String bpkg;
    private final String sdir;
    private final String ddir;
    private static String fileHeader = "// DO NOT EDIT THIS FILE DIRECTLY! - AUTOMATICALLY GENERATED\n// Generated by: " + RadiusDictionary.class.toString() + "\n" + "// Generated on: " + new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z").format(Calendar.getInstance().getTime()) + "\n";
    private LinkedHashMap attrMap = new LinkedHashMap();
    private LinkedHashMap vendorMap = new LinkedHashMap();
    private LinkedHashMap seenNames = new LinkedHashMap();
    private LinkedHashMap classNames = new LinkedHashMap();
    private String cVendor = null;
    private String cTLV = null;

    public RadiusDictionary(Reader in, String pkgName, String dictDir, String srcDir) throws IOException {
        this.bpkg = pkgName;
        this.ddir = dictDir;
        this.sdir = srcDir;
        this.readFile(new BufferedReader(in));
        if (!this.haveSeenJRadius) {
            try {
                this.readFile(new BufferedReader(new FileReader(dictDir + "/" + "dictionary.jradius")));
            }
            catch (Exception e) {
                RadiusLog.error("WARNING!! You have not included the JRadius Dictionary (dictionary.jradius)");
            }
        }
    }

    public RadiusDictionary(String fileName, String pkgName, String dictDir, String srcDir) throws IOException {
        this(new FileReader(dictDir + "/" + fileName), pkgName, dictDir, srcDir);
    }

    public void readFile(BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            String attrName;
            String[] parts;
            String upperLine = (line = line.trim()).toUpperCase();
            if (upperLine.startsWith("#")) continue;
            if (upperLine.startsWith("$INCLUDE")) {
                parts = line.split("[\t ]+");
                String file = parts[1];
                if ("dictionary.jradius".equals(file)) {
                    this.haveSeenJRadius = true;
                }
                RadiusLog.info("Including file: " + file);
                this.readFile(new BufferedReader(new FileReader(this.ddir + "/" + file)));
                continue;
            }
            if (upperLine.startsWith("BEGIN-TLV")) {
                parts = line.split("[\t ]+");
                this.cTLV = parts[1];
                continue;
            }
            if (upperLine.startsWith("END-TLV")) {
                this.cTLV = null;
                continue;
            }
            if (upperLine.startsWith("BEGIN-VENDOR")) {
                parts = line.split("[\t ]+");
                this.cVendor = parts[1];
                continue;
            }
            if (upperLine.startsWith("END-VENDOR")) {
                this.cVendor = null;
                continue;
            }
            if (upperLine.startsWith("ATTRIBUTE")) {
                parts = line.split("[\t ]+");
                attrName = null;
                String attrNum = null;
                String attrType = null;
                String attrExtra = null;
                String attrVendor = null;
                VendorDesc vdesc = null;
                for (int i = 1; i < parts.length; ++i) {
                    String p = parts[i].trim();
                    if (p.length() == 0) continue;
                    if (attrName == null) {
                        attrName = p;
                        continue;
                    }
                    if (attrNum == null) {
                        attrNum = p;
                        continue;
                    }
                    if (attrType == null) {
                        attrType = p;
                        continue;
                    }
                    vdesc = (VendorDesc)this.vendorMap.get(p);
                    if (vdesc != null) {
                        attrVendor = p;
                        continue;
                    }
                    attrExtra = p;
                }
                if (attrName == null || attrNum == null || attrType == null || this.seenNames.containsKey(attrName.toLowerCase())) continue;
                LinkedHashMap map = this.attrMap;
                if (attrVendor == null && this.cVendor != null) {
                    attrVendor = this.cVendor;
                    vdesc = (VendorDesc)this.vendorMap.get(this.cVendor);
                }
                if (vdesc != null) {
                    if (this.cTLV != null) {
                        AttrDesc attrDesc = (AttrDesc)vdesc.attrMap.get(this.cTLV);
                        if (attrDesc.subAttributes == null) {
                            attrDesc.subAttributes = new LinkedHashMap();
                        }
                        map = attrDesc.subAttributes;
                    } else {
                        map = vdesc.attrMap;
                    }
                }
                map.put(attrName, new AttrDesc(attrName, attrNum, attrType, attrExtra, attrVendor));
                System.out.println("Seen = " + attrName);
                this.seenNames.put(attrName.toLowerCase(), attrNum);
                continue;
            }
            if (upperLine.startsWith("VALUE")) {
                AttrValueDesc avd;
                parts = line.split("[\t ]+");
                attrName = null;
                String attrValueName = null;
                String attrValueNum = null;
                for (int i = 1; i < parts.length; ++i) {
                    String p = parts[i].trim();
                    if (p.length() == 0) continue;
                    if (attrName == null) {
                        attrName = p;
                        continue;
                    }
                    if (attrValueName == null) {
                        attrValueName = p;
                        continue;
                    }
                    if (attrValueNum != null) continue;
                    attrValueNum = p;
                }
                if (attrName == null || attrValueNum == null || attrValueName == null) continue;
                AttrDesc desc = (AttrDesc)this.attrMap.get(attrName);
                if (desc == null && this.cVendor != null) {
                    VendorDesc vendorDesc = (VendorDesc)this.vendorMap.get(this.cVendor);
                    desc = (AttrDesc)vendorDesc.attrMap.get(attrName);
                }
                if (desc == null) continue;
                if (desc.values == null) {
                    desc.values = new LinkedHashMap();
                }
                if ((avd = (AttrValueDesc)desc.values.get(attrValueNum)) == null) {
                    desc.values.put(attrValueNum, new AttrValueDesc(attrValueName, attrValueNum));
                    continue;
                }
                avd.addName(attrValueName);
                continue;
            }
            if (!upperLine.startsWith("VENDOR")) continue;
            parts = line.split("[\t ]+");
            String vendorName = null;
            String vendorNum = null;
            String vendorExtra = null;
            String vendorPkg = null;
            for (int i = 1; i < parts.length; ++i) {
                String p = parts[i].trim();
                if (p.length() == 0) continue;
                if (vendorName == null) {
                    vendorName = p;
                    continue;
                }
                if (vendorNum == null) {
                    vendorNum = p;
                    continue;
                }
                if (vendorExtra != null) continue;
                vendorExtra = p;
            }
            if (vendorName == null || vendorNum == null) continue;
            String vendor = "vsa_" + vendorName.toLowerCase().replaceAll("-", ".");
            vendorPkg = this.bpkg + "." + vendor;
            if (vendorExtra != null) {
                // empty if block
            }
            this.vendorMap.put(vendorName, new VendorDesc(vendorName, vendorNum, vendorPkg, vendorExtra));
        }
    }

    public void writeAttrMap(Map map, String pkg, String vName, String cName, String pName, boolean withVendors) {
        String dir = this.sdir + "/" + pkg.replaceAll("\\.", "/");
        Iterator iter = map.values().iterator();
        String dictFile = dir + "/" + cName + ".java";
        PrintWriter dict = null;
        StringBuffer loadAttributes = new StringBuffer();
        StringBuffer loadAttributesNames = new StringBuffer();
        new File(dir).mkdirs();
        if (cName != null) {
            try {
                dict = new PrintWriter(new FileWriter(dictFile));
                dict.println(fileHeader);
                dict.println("package " + pkg + ";");
                dict.println("");
                dict.println("import java.util.Map;");
                dict.println("");
                if (withVendors) {
                    dict.println("import net.jradius.packet.attribute.AttributeDictionary;");
                } else {
                    dict.println("import net.jradius.packet.attribute.VSADictionary;");
                }
                dict.println("");
                dict.println("/**");
                dict.println(" * Dictionary for package " + pkg);
                dict.println(" * @author " + RadiusDictionary.class.toString());
                dict.println(" */");
                dict.print("public class " + cName);
                if (withVendors) {
                    dict.print(" implements AttributeDictionary");
                } else {
                    dict.print(" implements VSADictionary");
                }
                dict.println("\n{");
                if (withVendors) {
                    dict.println("    public void loadVendorCodes(Map<Long, Class<?>> map)");
                    dict.println("    {");
                    for (VendorDesc vdesc : this.vendorMap.values()) {
                        dict.println("        map.put(new Long(" + vdesc.num + "L), " + vdesc.pkg + ".VSADictionaryImpl.class);");
                    }
                    dict.println("    }");
                    dict.println("");
                } else {
                    dict.println("    public String getVendorName() { return \"" + vName + "\"; }\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            loadAttributes.append("    public void loadAttributes(Map<Long, Class<?>> map)\n");
            loadAttributes.append("    {\n");
            loadAttributesNames.append("    public void loadAttributesNames(Map<String, Class<?>> map)\n");
            loadAttributesNames.append("    {\n");
        }
        while (iter.hasNext()) {
            VendorDesc vdesc;
            AttrDesc desc = (AttrDesc)iter.next();
            vdesc = null;
            StringBuffer fileSB = new StringBuffer(dir);
            String pkgPath = pkg;
            if (withVendors && desc.vendor != null) {
                String vendor = "vsa_" + desc.vendor.toLowerCase().replaceAll("-", ".");
                fileSB.append("/").append(vendor.replaceAll("\\.", "/"));
                pkgPath = pkgPath + "." + vendor;
            }
            if (desc.vendor != null) {
                vdesc = (VendorDesc)this.vendorMap.get(desc.vendor);
            }
            String implementsInterface = null;
            String className = "Attr_" + this.clean(desc.name);
            String parentName = "RadiusAttribute";
            if (!withVendors) {
                parentName = "VSAttribute";
            }
            String parentImport = parentName;
            if (desc.subAttributes != null) {
                parentName = "VSAWithSubAttributes";
                parentImport = "VSAWithSubAttributes";
            }
            if (pName != null) {
                parentName = "SubAttribute";
                parentImport = "SubAttribute";
            }
            String valueClass = "OctetsValue";
            String valueArgs = "";
            String extraImport = null;
            String extraUtils = null;
            int integerLength = 4;
            new File(fileSB.toString()).mkdirs();
            fileSB.append("/").append(className).append(".java");
            String file = fileSB.toString();
            if (desc.type.startsWith("string")) {
                valueClass = desc.extra != null && "encrypt=1".equals(desc.extra) ? "EncryptedStringValue" : "StringValue";
            }
            if (desc.type.startsWith("integer")) {
                valueClass = "IntegerValue";
            }
            if (desc.type.startsWith("singed")) {
                valueClass = "IntegerValue";
            }
            if (desc.type.startsWith("date")) {
                valueClass = "DateValue";
                extraUtils = "import java.util.Date;\n";
            }
            if (desc.type.startsWith("ipaddr")) {
                valueClass = "IPAddrValue";
                extraUtils = "import java.net.InetAddress;\n";
            }
            if (desc.type.startsWith("ipv6addr")) {
                valueClass = "IPv6AddrValue";
                extraUtils = "import java.net.InetAddress;\n";
            }
            if (desc.type.startsWith("byte")) {
                valueClass = "IntegerValue";
                integerLength = 1;
            }
            if (desc.type.startsWith("short")) {
                valueClass = "IntegerValue";
                integerLength = 2;
            }
            if (desc.type.startsWith("signed")) {
                valueClass = "SignedValue";
            }
            if (desc.type.startsWith("combo-ip")) {
                valueClass = "ComboIPAddrValue";
            }
            if (desc.values != null) {
                valueClass = "NamedValue";
                valueArgs = "map != null ? map : (map = new NamedValueMap())";
            }
            if (desc.subAttributes != null) {
                valueClass = "TLVValue";
                valueArgs = "VENDOR_ID, VSA_TYPE, getSubAttributes()";
            }
            try {
                PrintWriter writer = new PrintWriter(new FileWriter(file));
                writer.println(fileHeader);
                writer.println("package " + pkgPath + ";");
                writer.println("");
                writer.println("import java.io.Serializable;");
                if (desc.values != null) {
                    writer.println("import java.util.LinkedHashMap;");
                    writer.println("import java.util.Map;");
                    writer.println("");
                }
                if (extraUtils != null) {
                    writer.println(extraUtils);
                    writer.println("");
                }
                writer.println("import net.jradius.packet.attribute." + parentImport + ";");
                if (implementsInterface != null) {
                    writer.println("import net.jradius.packet.attribute." + implementsInterface + ";");
                }
                writer.println("import net.jradius.packet.attribute.value." + valueClass + ";");
                if (desc.values != null && integerLength < 4) {
                    writer.println("import net.jradius.packet.attribute.value.IntegerValue;");
                }
                if (extraImport != null) {
                    writer.println("import net.jradius.packet.attribute.value." + extraImport + ";");
                }
                writer.println("");
                writer.println("/**");
                writer.println(" * Attribute Name: " + desc.name + "<br>");
                if (withVendors) {
                    writer.print(" * Attribute Type: " + desc.num);
                    if (this.parseInt(desc.num) > 255) {
                        writer.print(" (FreeRADIUS Internal Attribute)<br>");
                    }
                    writer.println("<br>");
                } else {
                    writer.println(" * Attribute Type: 26<br>");
                    writer.println(" * Vendor Id: " + vdesc.num + "<br>");
                    writer.println(" * VSA Type: " + desc.num + "<br>");
                }
                writer.println(" * Value Type: " + valueClass + "<br>");
                if (desc.values != null) {
                    writer.println(" * Possible Values: <br>");
                    writer.println(" * <ul>");
                    for (AttrValueDesc avdesc : desc.values.values()) {
                        Iterator i = avdesc.names.iterator();
                        while (i.hasNext()) {
                            writer.println(" * <li> " + i.next() + " (" + avdesc.num + ")");
                        }
                    }
                    writer.println(" * </ul>");
                }
                this.classNames.put(className, desc.num);
                writer.println(" *");
                writer.println(" * @author " + RadiusDictionary.class.toString());
                writer.println(" */");
                writer.println("public final class " + className + " extends " + parentName + (implementsInterface != null ? " implements " + implementsInterface : ""));
                writer.println("{");
                writer.println("    public static final String NAME = \"" + desc.name + "\";");
                String attributeType = desc.num;
                if (pName != null) {
                    writer.println("    public static final int VENDOR_ID = " + ((VendorDesc)this.vendorMap.get((Object)desc.vendor)).num + ";");
                    writer.println("    public static final int PARENT_TYPE = " + this.classNames.get(pName) + ";");
                    writer.println("    public static final int VSA_TYPE = (" + desc.num + " << 8) | PARENT_TYPE;");
                    writer.println("    public static final long TYPE = ((VENDOR_ID & 0xFFFF) << 16) | VSA_TYPE;");
                } else if (withVendors) {
                    writer.println("    public static final long TYPE = " + desc.num + ";");
                } else {
                    attributeType = "26";
                    writer.println("    public static final int VENDOR_ID = " + ((VendorDesc)this.vendorMap.get((Object)desc.vendor)).num + ";");
                    writer.println("    public static final int VSA_TYPE = " + desc.num + ";");
                    writer.println("    public static final long TYPE = ((VENDOR_ID & 0xFFFF) << 16) | VSA_TYPE;");
                }
                writer.println("");
                writer.println("    public static final long serialVersionUID = TYPE;");
                writer.println("");
                if (desc.values != null) {
                    Iterator iter2 = desc.values.values().iterator();
                    LinkedHashMap<String, String> names = new LinkedHashMap<String, String>();
                    while (iter2.hasNext()) {
                        AttrValueDesc avdesc = (AttrValueDesc)iter2.next();
                        Iterator i = avdesc.names.iterator();
                        while (i.hasNext()) {
                            String name = this.clean((String)i.next());
                            if (names.get(name) != null) continue;
                            names.put(name, name);
                            String pubName = name;
                            if ("true".equals(pubName) || "false".equals(pubName)) {
                                pubName = pubName.toUpperCase();
                            }
                            writer.println("    public static final Long " + pubName + " = new Long(" + avdesc.num + "L);");
                        }
                    }
                    writer.println("");
                    writer.println("    protected class NamedValueMap implements NamedValue.NamedValueMap");
                    writer.println("    {");
                    iter2 = desc.values.values().iterator();
                    String pvalues = " ";
                    while (iter2.hasNext()) {
                        AttrValueDesc avdesc = (AttrValueDesc)iter2.next();
                        pvalues = pvalues + "new Long(" + avdesc.num + "L),";
                    }
                    writer.println("        public Long[] knownValues = {" + pvalues.substring(0, pvalues.length() - 1) + "};");
                    writer.println("");
                    writer.println("        public Long[] getKnownValues() { return knownValues; }");
                    writer.println("");
                    writer.println("        public Long getNamedValue(String name)");
                    writer.println("        {");
                    for (AttrValueDesc avdesc : desc.values.values()) {
                        for (String name : avdesc.names) {
                            writer.println("            if (\"" + name + "\".equals(name)) return new Long(" + avdesc.num + "L);");
                        }
                    }
                    writer.println("            return null;");
                    writer.println("        }");
                    writer.println("");
                    writer.println("        public String getNamedValue(Long value)");
                    writer.println("        {");
                    for (AttrValueDesc avdesc : desc.values.values()) {
                        String name;
                        Iterator i = avdesc.names.iterator();
                        if (i == null || !i.hasNext()) continue;
                        name = (String)i.next();
                        writer.println("            if (new Long(" + avdesc.num + "L).equals(value)) return \"" + name + "\";");
                    }
                    writer.println("            return null;");
                    writer.println("        }");
                    writer.println("    };");
                    writer.println("");
                    writer.println("    public static NamedValueMap map = null;");
                }
                writer.println("    public void setup()");
                writer.println("    {");
                writer.println("        attributeName = NAME;");
                writer.println("        attributeType = " + attributeType + ";");
                if (pName != null) {
                    writer.println("        setParentClass(" + pName + ".class);");
                }
                if (pName != null || !withVendors) {
                    writer.println("        vendorId = VENDOR_ID;");
                    writer.println("        vsaAttributeType = VSA_TYPE;");
                }
                if (vdesc != null && vdesc.getFormat() != null) {
                    writer.println("        setFormat(\"" + vdesc.getFormat() + "\");");
                }
                writer.println("        attributeValue = new " + valueClass + "(" + valueArgs + ");");
                if (valueClass.equals("IntegerValue") && integerLength < 4) {
                    writer.println("        ((IntegerValue)attributeValue).setLength(" + integerLength + ");");
                }
                writer.println("    }");
                writer.println("");
                writer.println("    public " + className + "()");
                writer.println("    {");
                writer.println("        setup();");
                writer.println("    }");
                writer.println("");
                writer.println("    public " + className + "(Serializable o)");
                writer.println("    {");
                writer.println("        setup(o);");
                writer.println("    }");
                writer.println("}");
                writer.close();
                if (cName != null && !withVendors || desc.vendor == null) {
                    loadAttributes.append("        map.put(new Long(" + desc.num + "L), " + className + ".class);\n");
                    loadAttributesNames.append("        map.put(" + className + ".NAME, " + className + ".class);\n");
                    if (desc.subAttributes != null) {
                        for (Object obj : desc.subAttributes.values()) {
                            AttrDesc at = (AttrDesc)obj;
                            String cn = "Attr_" + this.clean(at.name);
                            long value = Integer.parseInt(at.num) << 8 | Integer.parseInt(desc.num) & 0xFF;
                            loadAttributes.append("        map.put(new Long(" + value + "L), " + cn + ".class);\n");
                            loadAttributesNames.append("        map.put(" + cn + ".NAME, " + cn + ".class);\n");
                        }
                    }
                }
            }
            catch (Exception e) {
                RadiusLog.error(e.getMessage(), e);
            }
            if (desc.subAttributes != null) {
                this.writeAttrMap(desc.subAttributes, pkg, vName, null, className, false);
            }
            RadiusLog.info(desc.name);
        }
        loadAttributes.append("    }\n");
        loadAttributesNames.append("    }\n");
        if (dict != null) {
            dict.println(loadAttributes.toString());
            dict.print(loadAttributesNames.toString());
            try {
                dict.println("}");
                dict.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (withVendors) {
            for (VendorDesc vdesc : this.vendorMap.values()) {
                this.writeAttrMap(vdesc.attrMap, vdesc.pkg, vdesc.name, "VSADictionaryImpl", null, false);
            }
        }
    }

    public int parseInt(String s) {
        if (s.startsWith("0x")) {
            return Integer.parseInt(s.substring(2), 16);
        }
        return Integer.parseInt(s);
    }

    public void writeJavaClasses() {
        this.writeAttrMap(this.attrMap, this.bpkg, null, "AttributeDictionaryImpl", null, true);
    }

    private String clean(String s) {
        s = s.replaceAll("-", "_");
        if (Character.isDigit((s = s.replaceAll("[^a-zA-Z0-9]+", "")).charAt(0))) {
            s = "_" + s;
        }
        return s;
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("Requires 3 arguments: [package-name] [dictionary-dir] [java-src-dir]");
            System.err.println("\tpackage-name:    Name of the Java package to be built (e.g. net.jradius.dictionary)");
            System.err.println("\tdictionary-dir:  Directory where the FreeRADIUS 'dictionary' file is");
            System.err.println("\tjava-src--dir:   Directory where to write Java classes");
            return;
        }
        String file = "dictionary";
        String pkg = args[0];
        String dDir = args[1];
        String jDir = args[2];
        try {
            RadiusDictionary d = new RadiusDictionary(file, pkg, dDir, jDir);
            d.writeJavaClasses();
        }
        catch (Exception e) {
            RadiusLog.error(e.getMessage(), e);
        }
    }

    class VendorDesc {
        public String name;
        public String num;
        public String pkg;
        public String extra;
        public LinkedHashMap attrMap = new LinkedHashMap();

        public VendorDesc(String n, String m, String p, String e) {
            this.name = n;
            this.num = m;
            this.pkg = p;
            this.extra = e;
        }

        public String getFormat() {
            if (this.extra != null && this.extra.startsWith("format=")) {
                return this.extra.substring(7);
            }
            return null;
        }
    }

    class AttrValueDesc {
        public LinkedList names = new LinkedList();
        public String num;

        public AttrValueDesc(String n, String m) {
            this.num = m;
            this.names.add(n);
        }

        public void addName(String n) {
            Iterator i = this.names.iterator();
            while (i.hasNext()) {
                if (!i.next().equals(n)) continue;
                return;
            }
            this.names.add(n);
        }
    }

    class AttrDesc {
        public String name;
        public String num;
        public String type;
        public String extra;
        public String vendor;
        public LinkedHashMap values = null;
        public LinkedHashMap subAttributes = null;

        public AttrDesc(String n, String m, String t, String e, String v) {
            this.name = n;
            this.num = m;
            this.type = t;
            this.extra = e;
            this.vendor = v;
        }
    }
}

