/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.persistence;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.ibatis.jdbc.SQL;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.mybatis.jpa.PageResultsSqlCache;
import org.apache.mybatis.jpa.id.IdentifierGeneratorFactory;
import org.apache.mybatis.jpa.persistence.FieldColumnMapper;
import org.apache.mybatis.jpa.persistence.JpaBaseDomain;
import org.apache.mybatis.jpa.persistence.JpaBaseService;
import org.apache.mybatis.jpa.persistence.JpaPagination;
import org.apache.mybatis.jpa.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperSqlProvider<T extends JpaBaseDomain> {
    private static final Logger _logger = LoggerFactory.getLogger(MapperSqlProvider.class);
    public static String ENTITY_CLASS = "entityClass";
    private static boolean TABLE_COLUMN_UPCASE = true;
    private static transient ConcurrentMap<String, List<FieldColumnMapper>> fieldsMap = new ConcurrentHashMap<String, List<FieldColumnMapper>>();
    private static transient ConcurrentMap<String, String> sqlsMap = new ConcurrentHashMap<String, String>();
    private static IdentifierGeneratorFactory identifierGeneratorFactory = new IdentifierGeneratorFactory();

    public String get(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get(ENTITY_CLASS);
        this.buildColumnList(entityClass);
        if (sqlsMap.containsKey(String.valueOf(this.getTableName(entityClass)) + SQL_TYPE.GET_SQL)) {
            return (String)sqlsMap.get(String.valueOf(this.getTableName(entityClass)) + SQL_TYPE.GET_SQL);
        }
        FieldColumnMapper idFieldColumnMapper = this.getIdColumn(entityClass.getSimpleName());
        SQL sql = new SQL();
        sql.SELECT(" * ");
        sql.FROM(this.getTableName(entityClass));
        sql.WHERE(String.valueOf(idFieldColumnMapper.getColumnName()) + " = #{" + idFieldColumnMapper.getFieldName() + "}");
        String getSql = sql.toString();
        _logger.trace("Get SQL \n" + getSql);
        sqlsMap.put(String.valueOf(this.getTableName(entityClass)) + SQL_TYPE.GET_SQL, getSql);
        return getSql;
    }

    public String findAll(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get(ENTITY_CLASS);
        this.buildColumnList(entityClass);
        if (sqlsMap.containsKey(String.valueOf(this.getTableName(entityClass)) + SQL_TYPE.FINDALL_SQL)) {
            return (String)sqlsMap.get(String.valueOf(this.getTableName(entityClass)) + SQL_TYPE.FINDALL_SQL);
        }
        SQL sql = new SQL();
        sql.SELECT(" * ");
        sql.FROM(this.getTableName(entityClass));
        String findAllSql = sql.toString();
        _logger.trace("Find All SQL \n" + findAllSql);
        sqlsMap.put(String.valueOf(this.getTableName(entityClass)) + SQL_TYPE.FINDALL_SQL, findAllSql);
        return findAllSql;
    }

    public String remove(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get(ENTITY_CLASS);
        this.buildColumnList(entityClass);
        if (sqlsMap.containsKey(String.valueOf(this.getTableName(entityClass)) + SQL_TYPE.REMOVE_SQL)) {
            return (String)sqlsMap.get(String.valueOf(this.getTableName(entityClass)) + SQL_TYPE.REMOVE_SQL);
        }
        FieldColumnMapper idFieldColumnMapper = this.getIdColumn(entityClass.getSimpleName());
        SQL sql = new SQL();
        sql.DELETE_FROM(this.getTableName(entityClass));
        sql.WHERE(String.valueOf(idFieldColumnMapper.getColumnName()) + " = #{" + idFieldColumnMapper.getFieldName() + ",javaType=string,jdbcType=VARCHAR}");
        String deleteSql = sql.toString();
        _logger.trace("Delete SQL \n" + deleteSql);
        sqlsMap.put(String.valueOf(this.getTableName(entityClass)) + SQL_TYPE.REMOVE_SQL, deleteSql);
        return deleteSql;
    }

    public String batchDelete(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get(ENTITY_CLASS);
        this.buildColumnList(entityClass);
        ArrayList idValues = (ArrayList)parametersMap.get("idList");
        String keyValue = "";
        for (String value : idValues) {
            keyValue = String.valueOf(keyValue) + ",'" + value + "'";
        }
        keyValue = keyValue.substring(1);
        FieldColumnMapper idFieldColumnMapper = this.getIdColumn(entityClass.getSimpleName());
        SQL sql = new SQL();
        sql.DELETE_FROM(this.getTableName(entityClass));
        sql.WHERE(String.valueOf(idFieldColumnMapper.getColumnName()) + " IN ( " + keyValue + " )");
        String deleteSql = sql.toString();
        _logger.trace("Delete SQL \n" + deleteSql);
        sqlsMap.put(String.valueOf(this.getTableName(entityClass)) + SQL_TYPE.REMOVE_SQL, deleteSql);
        return deleteSql;
    }

    public String insert(T entity) {
        this.buildColumnList(entity.getClass());
        List listFields = (List)fieldsMap.get(entity.getClass().getSimpleName());
        SQL sql = new SQL();
        sql.INSERT_INTO(this.getTableName(entity.getClass()));
        int i = 0;
        while (i < listFields.size()) {
            FieldColumnMapper fieldColumnMapper = (FieldColumnMapper)listFields.get(i);
            if (!fieldColumnMapper.getFieldType().equalsIgnoreCase("String") || BeanUtil.getValue(entity, fieldColumnMapper.getFieldName()) != null || fieldColumnMapper.getGeneratedValue() != null) {
                if (fieldColumnMapper.getGeneratedValue() != null) {
                    GeneratedValue generatedValue = ((FieldColumnMapper)listFields.get(i)).getGeneratedValue();
                    if (generatedValue.strategy() == GenerationType.AUTO) {
                        if (identifierGeneratorFactory.getGeneratorStrategyMap().containsKey(generatedValue.generator().toLowerCase())) {
                            BeanUtil.set(entity, fieldColumnMapper.getFieldName(), identifierGeneratorFactory.generate(generatedValue.generator().toLowerCase()));
                            sql.VALUES(fieldColumnMapper.getColumnName(), "#{" + fieldColumnMapper.getFieldName() + "}");
                        }
                    } else if (generatedValue.strategy() == GenerationType.SEQUENCE) {
                        sql.VALUES(fieldColumnMapper.getColumnName(), String.valueOf(generatedValue.generator()) + ".NEXTVAL");
                    } else if (generatedValue.strategy() != GenerationType.IDENTITY) {
                        generatedValue.strategy();
                    }
                } else {
                    sql.VALUES(fieldColumnMapper.getColumnName(), "#{" + fieldColumnMapper.getFieldName() + "}");
                }
            }
            ++i;
        }
        _logger.trace("Insert SQL : \n" + sql);
        return sql.toString();
    }

    public String update(T entity) {
        this.buildColumnList(entity.getClass());
        List listFields = (List)fieldsMap.get(entity.getClass().getSimpleName());
        SQL sql = new SQL();
        sql.UPDATE(this.getTableName(entity.getClass()));
        int i = 0;
        while (i < listFields.size()) {
            FieldColumnMapper fieldColumnMapper = (FieldColumnMapper)listFields.get(i);
            if (!(fieldColumnMapper.isIdColumn() || fieldColumnMapper.getFieldType().equalsIgnoreCase("String") && BeanUtil.getValue(entity, fieldColumnMapper.getFieldName()) == null)) {
                sql.SET(String.valueOf(fieldColumnMapper.getColumnName()) + "=#{" + fieldColumnMapper.getFieldName() + "}");
            }
            ++i;
        }
        FieldColumnMapper idFieldColumnMapper = this.getIdColumn(entity.getClass().getSimpleName());
        sql.WHERE(String.valueOf(idFieldColumnMapper.getColumnName()) + "=#{" + idFieldColumnMapper.getFieldName() + "}");
        _logger.trace("Update SQL : \n" + sql);
        return sql.toString();
    }

    public String queryPageResultsCount(T entity) {
        T pagination = entity;
        PageResultsSqlCache pageResultsSqlCache = (PageResultsSqlCache)JpaBaseService.pageResultsBoundSqlCache.get((Object)((JpaPagination)pagination).getPageResultSelectUUID());
        String selectSql = pageResultsSqlCache.getSql();
        BoundSql boundSql = pageResultsSqlCache.getBoundSql();
        StringBuffer sql = new StringBuffer();
        StringBuffer countSql = new StringBuffer();
        if (boundSql.getParameterMappings() == null || boundSql.getParameterMappings().isEmpty()) {
            countSql.append(selectSql);
        } else {
            for (ParameterMapping parameterMapping : boundSql.getParameterMappings()) {
                countSql.append(selectSql.substring(0, selectSql.indexOf("?")));
                countSql.append("#{" + parameterMapping.getProperty() + "}");
                selectSql = selectSql.substring(selectSql.indexOf("?") + 1);
            }
        }
        if (countSql.toString().toUpperCase().indexOf("DISTINCT") > 0) {
            sql.append("SELECT COUNT(1) COUNTROWS_ FROM (").append(countSql).append(" ) COUNT_TABLE_");
        } else {
            sql.append("SELECT COUNT(1) COUNTROWS_ ").append(countSql.substring(countSql.toString().toUpperCase().indexOf("FROM")));
        }
        JpaBaseService.pageResultsBoundSqlCache.remove((Object)((JpaPagination)pagination).getPageResultSelectUUID());
        _logger.trace("Count SQL : \n" + sql);
        return sql.toString();
    }

    public String query(T entity) {
        this.buildColumnList(entity.getClass());
        SQL sql = new SQL();
        sql.SELECT(" * ");
        sql.FROM(this.getTableName(entity.getClass()));
        for (FieldColumnMapper fieldColumnMapper : (List)fieldsMap.get(entity.getClass().getSimpleName())) {
            if (fieldColumnMapper.getFieldType().equalsIgnoreCase("String") && BeanUtil.getValue(entity, fieldColumnMapper.getFieldName()) == null) continue;
            sql.WHERE(String.valueOf(fieldColumnMapper.getColumnName()) + "=#{" + fieldColumnMapper.getFieldName() + "}");
        }
        return sql.toString();
    }

    public String getTableName(Class<?> entityClass) {
        Table table = entityClass.getAnnotation(Table.class);
        String tablename = "";
        tablename = table != null ? table.name() : entityClass.getClass().getSimpleName();
        return TABLE_COLUMN_UPCASE ? tablename.toUpperCase() : tablename;
    }

    public FieldColumnMapper getIdColumn(String classSimpleName) {
        List listFields = (List)fieldsMap.get(classSimpleName);
        FieldColumnMapper idFieldColumnMapper = null;
        int i = 0;
        while (i < listFields.size()) {
            if (((FieldColumnMapper)listFields.get(i)).isIdColumn()) {
                idFieldColumnMapper = (FieldColumnMapper)listFields.get(i);
                break;
            }
            ++i;
        }
        return idFieldColumnMapper;
    }

    public void buildColumnList(Class<?> entityClass) {
        if (fieldsMap.containsKey(entityClass.getSimpleName())) {
            return;
        }
        _logger.trace("entityClass " + entityClass);
        Field[] fields = entityClass.getDeclaredFields();
        ArrayList<FieldColumnMapper> fieldColumnMapperList = new ArrayList<FieldColumnMapper>(fields.length);
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(Column.class)) {
                FieldColumnMapper fieldColumnMapper = new FieldColumnMapper();
                fieldColumnMapper.setFieldName(field.getName());
                fieldColumnMapper.setFieldType(field.getType().getSimpleName());
                Column columnAnnotation = field.getAnnotation(Column.class);
                if (columnAnnotation.name() != null && !columnAnnotation.name().equals("")) {
                    fieldColumnMapper.setColumnName(columnAnnotation.name());
                } else if (TABLE_COLUMN_UPCASE) {
                    fieldColumnMapper.setColumnName(field.getName().toUpperCase());
                } else {
                    fieldColumnMapper.setColumnName(field.getName());
                }
                if (field.isAnnotationPresent(Id.class)) {
                    fieldColumnMapper.setIdColumn(true);
                }
                if (field.isAnnotationPresent(GeneratedValue.class)) {
                    GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
                    fieldColumnMapper.setGeneratedValue(generatedValue);
                }
                _logger.trace("FieldColumnMapper : " + fieldColumnMapper);
                fieldColumnMapperList.add(fieldColumnMapper);
            }
            ++n2;
        }
        fieldsMap.put(entityClass.getSimpleName(), fieldColumnMapperList);
        _logger.debug("fieldsMap : " + fieldsMap);
    }

    public static class SQL_TYPE {
        public static String GET_SQL = "_GET_SQL";
        public static String FINDALL_SQL = "_FINDALL_SQL";
        public static String REMOVE_SQL = "_REMOVE_SQL";
    }
}

