/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;
import org.xml.sax.SAXException;

public class XmlParserHelper {
    private static final Log log = LoggerFactory.make();
    private static final int NUMBER_OF_SCHEMAS = 4;
    private static final String DEFAULT_VERSION = "1.0";
    private final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private static final int READ_LIMIT = 0x100000;
    private static final ConcurrentMap<String, Schema> schemaCache = new ConcurrentHashMap<String, Schema>(4);

    public String getSchemaVersion(String resourceName, InputStream xmlInputStream) {
        Contracts.assertNotNull(xmlInputStream, Messages.MESSAGES.parameterMustNotBeNull("xmlInputStream"));
        xmlInputStream.mark(0x100000);
        try {
            XMLEventReader xmlEventReader = this.createXmlEventReader(xmlInputStream);
            StartElement rootElement = this.getRootElement(xmlEventReader);
            String string = this.getVersionValue(rootElement);
            return string;
        }
        catch (XMLStreamException e) {
            throw log.getUnableToDetermineSchemaVersionException(resourceName, e);
        }
        finally {
            try {
                xmlInputStream.reset();
            }
            catch (IOException e) {
                throw log.getUnableToResetXmlInputStreamException(resourceName, e);
            }
        }
    }

    private String getVersionValue(StartElement startElement) {
        if (startElement == null) {
            return null;
        }
        Attribute versionAttribute = startElement.getAttributeByName(new QName("version"));
        return versionAttribute != null ? versionAttribute.getValue() : DEFAULT_VERSION;
    }

    private StartElement getRootElement(XMLEventReader xmlEventReader) throws XMLStreamException {
        while (xmlEventReader.hasNext()) {
            XMLEvent nextEvent = xmlEventReader.nextEvent();
            if (!nextEvent.isStartElement()) continue;
            return nextEvent.asStartElement();
        }
        return null;
    }

    private synchronized XMLEventReader createXmlEventReader(InputStream xmlStream) throws XMLStreamException {
        return this.xmlInputFactory.createXMLEventReader(xmlStream);
    }

    public Schema getSchema(String schemaResource) {
        Schema schema = (Schema)schemaCache.get(schemaResource);
        if (schema != null) {
            return schema;
        }
        schema = this.loadSchema(schemaResource);
        Schema previous = schemaCache.putIfAbsent(schemaResource, schema);
        return previous != null ? previous : schema;
    }

    private Schema loadSchema(String schemaResource) {
        ClassLoader loader = ReflectionHelper.getClassLoaderFromClass(XmlParserHelper.class);
        URL schemaUrl = loader.getResource(schemaResource);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = sf.newSchema(schemaUrl);
        }
        catch (SAXException e) {
            log.unableToCreateSchema(schemaResource, e.getMessage());
        }
        return schema;
    }
}

