/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.statistics;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.ehcache.Cache;
import org.ehcache.Status;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.core.InternalCache;
import org.ehcache.core.events.CacheManagerListener;
import org.ehcache.core.spi.service.CacheManagerProviderService;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.spi.service.StatisticsServiceConfiguration;
import org.ehcache.core.spi.store.InternalCacheManager;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.core.statistics.CacheStatistics;
import org.ehcache.impl.internal.statistics.DefaultCacheStatistics;
import org.ehcache.impl.internal.statistics.DefaultStatisticsServiceConfiguration;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceDependencies(value={CacheManagerProviderService.class, TimeSourceService.class})
public class DefaultStatisticsService
implements StatisticsService,
CacheManagerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStatisticsService.class);
    private final StatisticsServiceConfiguration configuration;
    private final ConcurrentMap<String, CacheStatistics> cacheStatistics = new ConcurrentHashMap<String, CacheStatistics>();
    private volatile InternalCacheManager cacheManager;
    private volatile TimeSource timeSource;
    private volatile boolean started = false;

    public DefaultStatisticsService() {
        this(new DefaultStatisticsServiceConfiguration());
    }

    public DefaultStatisticsService(StatisticsServiceConfiguration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
    }

    @Override
    public StatisticsServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public CacheStatistics getCacheStatistics(String cacheName) {
        CacheStatistics stats = (CacheStatistics)this.cacheStatistics.get(cacheName);
        if (stats == null) {
            throw new IllegalArgumentException("Unknown cache: " + cacheName);
        }
        return stats;
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void start(ServiceProvider<Service> serviceProvider) {
        LOGGER.debug("Starting service");
        TimeSourceService timeSourceService = serviceProvider.getService(TimeSourceService.class);
        this.timeSource = timeSourceService.getTimeSource();
        CacheManagerProviderService cacheManagerProviderService = serviceProvider.getService(CacheManagerProviderService.class);
        this.cacheManager = cacheManagerProviderService.getCacheManager();
        this.cacheManager.registerListener(this);
        this.started = true;
    }

    @Override
    public void stop() {
        LOGGER.debug("Stopping service");
        this.cacheManager.deregisterListener(this);
        this.cacheStatistics.clear();
        this.started = false;
    }

    @Override
    public void stateTransition(Status from, Status to) {
        LOGGER.debug("Moving from " + (Object)((Object)from) + " to " + (Object)((Object)to));
        switch (to) {
            case AVAILABLE: {
                this.registerAllCaches();
                break;
            }
            case UNINITIALIZED: {
                this.cacheManager.deregisterListener(this);
                this.cacheStatistics.clear();
                break;
            }
            case MAINTENANCE: {
                throw new IllegalStateException("Should not be started in maintenance mode");
            }
            default: {
                throw new AssertionError((Object)("Unsupported state: " + (Object)((Object)to)));
            }
        }
    }

    private void registerAllCaches() {
        for (Map.Entry<String, CacheConfiguration<?, ?>> entry : this.cacheManager.getRuntimeConfiguration().getCacheConfigurations().entrySet()) {
            String alias = entry.getKey();
            CacheConfiguration<?, ?> configuration = entry.getValue();
            Cache<?, ?> cache = this.cacheManager.getCache(alias, configuration.getKeyType(), configuration.getValueType());
            this.cacheAdded(alias, cache);
        }
    }

    @Override
    public void cacheAdded(String alias, Cache<?, ?> cache) {
        LOGGER.debug("Cache added " + alias);
        this.cacheStatistics.put(alias, new DefaultCacheStatistics((InternalCache)cache, this.configuration, this.timeSource));
    }

    @Override
    public void cacheRemoved(String alias, Cache<?, ?> cache) {
        LOGGER.debug("Cache removed " + alias);
        this.cacheStatistics.remove(alias);
    }
}

