/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xpath.evaluator;

import org.apache.tsik.xpath.evaluator.InvocationContext;
import org.apache.tsik.xpath.evaluator.NodeTestEvaluator;
import org.apache.tsik.xpath.util.ExpandedName;
import org.apache.tsik.xpath.util.NodeArray;
import org.w3c.dom.Node;

public class ExpandedNameNodeTestEvaluator
extends NodeTestEvaluator {
    private String namespaceURI;
    private String localName;
    boolean wildcard;

    public ExpandedNameNodeTestEvaluator(ExpandedName name) {
        this.namespaceURI = name.getNamespaceURI();
        this.localName = name.getLocalName();
        if (this.localName == null) {
            this.localName = "*";
        }
        this.wildcard = this.localName.equals("*");
    }

    public void filter(InvocationContext invocationContext, NodeArray na, short principalNodeType) {
        int j = 0;
        int l = na.len;
        for (int i = 0; i < l; ++i) {
            Node node = na.nodes[i];
            if (node.getNodeType() != principalNodeType) continue;
            String nodeNamespaceURI = node.getNamespaceURI();
            String nodeLocalName = node.getLocalName();
            if (!this.wildcard && (this.localName == null || !this.localName.equals(nodeLocalName)) || (this.namespaceURI != null || nodeNamespaceURI != null) && (this.namespaceURI == null || !this.namespaceURI.equals(nodeNamespaceURI))) continue;
            na.nodes[j++] = node;
        }
        na.truncate(j);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.namespaceURI != null) {
            sb.append("\"");
            sb.append(this.namespaceURI);
            sb.append("\":");
        }
        sb.append(this.localName);
        return sb.toString();
    }
}

