/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xpath.evaluator;

import org.apache.tsik.xpath.Context;
import org.apache.tsik.xpath.evaluator.ExprEvaluator;
import org.apache.tsik.xpath.evaluator.InfixExprEvaluator;
import org.apache.tsik.xpath.util.Coerce;
import org.w3c.dom.NodeList;

public abstract class ComparisonExprEvaluator
extends InfixExprEvaluator {
    public ComparisonExprEvaluator(ExprEvaluator lhs, ExprEvaluator rhs) {
        super(lhs, rhs);
    }

    public Object evaluateOperator(Context context, Object lhv, Object rhv) {
        if (lhv instanceof NodeList && rhv instanceof NodeList) {
            NodeList lhnl = (NodeList)lhv;
            NodeList rhnl = (NodeList)rhv;
            int l = lhnl.getLength();
            for (int i = 0; i < l; ++i) {
                int m = rhnl.getLength();
                for (int j = 0; j < m; ++j) {
                    if (!this.evaluateComparison(context, Coerce.stringValueOfNode(lhnl.item(i)), Coerce.stringValueOfNode(rhnl.item(j)))) continue;
                    return Boolean.TRUE;
                }
            }
            return Boolean.FALSE;
        }
        if (lhv instanceof NodeList) {
            if (rhv instanceof Boolean) {
                return new Boolean(this.evaluateComparison(context, Coerce.toBoolean(lhv), rhv));
            }
            NodeList lhnl = (NodeList)lhv;
            int l = lhnl.getLength();
            for (int i = 0; i < l; ++i) {
                if (!this.evaluateComparison(context, Coerce.stringValueOfNode(lhnl.item(i)), rhv)) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (rhv instanceof NodeList) {
            if (lhv instanceof Boolean) {
                return new Boolean(this.evaluateComparison(context, lhv, Coerce.toBoolean(rhv)));
            }
            NodeList rhnl = (NodeList)rhv;
            int l = rhnl.getLength();
            for (int i = 0; i < l; ++i) {
                if (!this.evaluateComparison(context, lhv, Coerce.stringValueOfNode(rhnl.item(i)))) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return new Boolean(this.evaluateComparison(context, lhv, rhv));
    }

    public abstract boolean evaluateComparison(Context var1, Object var2, Object var3);
}

