/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig.elements;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementException;
import org.apache.tsik.domutil.elements.ElementExtension;
import org.apache.tsik.domutil.elements.ElementImpl;
import org.apache.tsik.util.Namespaces;
import org.apache.tsik.xmlsig.elements.KeyName;
import org.apache.tsik.xmlsig.elements.KeyValue;
import org.apache.tsik.xmlsig.elements.X509Data;
import org.apache.tsik.xmlsig.elements.X509IssuerSerial;

public class KeyInfo
extends ElementImpl {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$tsik$xmlsig$elements$KeyInfo == null ? (class$org$apache$tsik$xmlsig$elements$KeyInfo = KeyInfo.class$("org.apache.tsik.xmlsig.elements.KeyInfo")) : class$org$apache$tsik$xmlsig$elements$KeyInfo);
    public static final String name = "KeyInfo";
    protected static final String prefix = Namespaces.XMLSIG.getPrefix();
    public static final String uri = Namespaces.XMLSIG.getUri();
    protected static final String[] ns = new String[]{prefix, uri};
    private KeyName[] keyName = null;
    private KeyValue[] keyValue = null;
    private X509Data[] x509Data = null;
    private ElementExtension extension = null;
    static /* synthetic */ Class class$org$apache$tsik$xmlsig$elements$KeyInfo;

    public KeyInfo() {
    }

    public KeyInfo(org.apache.tsik.xmlsig.KeyInfo keyInfo) {
        byte[] ski;
        if (keyInfo.getKeyName() != null) {
            this.keyName = new KeyName[]{new KeyName(keyInfo.getKeyName())};
        }
        if (keyInfo.getKeyValue() != null) {
            this.keyValue = new KeyValue[]{new KeyValue(keyInfo.getKeyValue())};
        }
        Vector<X509Certificate> certVector = null;
        X509Certificate[] certs = keyInfo.getCertificateChain();
        if (certs != null && certs.length > 0) {
            certVector = new Vector<X509Certificate>();
            for (int i = 0; i < certs.length; ++i) {
                certVector.add(certs[i]);
            }
        }
        X509IssuerSerial is = null;
        if (keyInfo.getIssuerName() != null) {
            is = new X509IssuerSerial(keyInfo.getIssuerName(), keyInfo.getSerialNumber());
        }
        String subject = keyInfo.getSubjectName();
        byte[] byArray = ski = certVector == null ? keyInfo.getKeyIdentifier() : null;
        if (certVector != null || is != null || subject != null || ski != null) {
            X509Data data = new X509Data(is, ski, subject, certVector, null);
            this.x509Data = new X509Data[]{data};
        }
    }

    public org.apache.tsik.xmlsig.KeyInfo getKeyInfo() {
        X509Certificate[] certs;
        org.apache.tsik.xmlsig.KeyInfo keyInfo = new org.apache.tsik.xmlsig.KeyInfo();
        if (this.keyName != null && this.keyName.length > 0) {
            keyInfo.setKeyName(this.keyName[0].getKeyName());
        }
        if (this.keyValue != null && this.keyValue.length > 0) {
            keyInfo.setKeyValue(this.keyValue[0].getPublicKey());
        }
        X509Data data = null;
        if (this.x509Data != null && this.x509Data.length > 0) {
            data = this.x509Data[0];
        }
        if (data != null && data.getSKI() != null) {
            keyInfo.setKeyIdentifier(data.getSKI());
        }
        if ((certs = this.getCertificateChain()) != null && certs.length > 0) {
            keyInfo.setCertificateChain(certs);
        } else if (data != null) {
            X509IssuerSerial is;
            if (data.getSubjectName() != null) {
                keyInfo.setSubjectName(data.getSubjectName());
            }
            if ((is = data.getIssuerSerial()) != null && is.getIssuerName() != null) {
                keyInfo.setIssuerSerial(is.getIssuerName(), is.getSerialNumber());
            }
        }
        return keyInfo;
    }

    public KeyValue getKeyValue() {
        if (this.keyValue != null) {
            return this.keyValue[0];
        }
        this.explodeCertificate();
        if (this.keyValue != null) {
            return this.keyValue[0];
        }
        return null;
    }

    public void addKeyValue(PublicKey publicKey) {
        int len = this.keyValue == null ? 0 : this.keyValue.length;
        KeyValue[] temp = new KeyValue[len + 1];
        temp[len] = new KeyValue(publicKey);
        this.keyValue = new KeyValue[temp.length];
        System.arraycopy(temp, 0, this.keyValue, 0, temp.length);
    }

    public void addCertificate(X509Certificate cert) {
        int len = this.x509Data == null ? 0 : this.x509Data.length;
        X509Data[] temp = new X509Data[len + 1];
        temp[len] = new X509Data(cert);
        this.x509Data = new X509Data[temp.length];
        System.arraycopy(temp, 0, this.x509Data, 0, temp.length);
    }

    public void addCertificateChain(X509Certificate[] chain) {
        int len = this.x509Data == null ? 0 : this.x509Data.length;
        X509Data[] temp = new X509Data[len + 1];
        temp[len] = new X509Data(chain);
        this.x509Data = new X509Data[temp.length];
        System.arraycopy(temp, 0, this.x509Data, 0, temp.length);
    }

    public X509Certificate getCertificate() {
        if (this.x509Data != null) {
            return this.x509Data[0].getCertificate();
        }
        return null;
    }

    public X509Certificate[] getCertificateChain() {
        if (this.x509Data != null) {
            return this.x509Data[0].getCertificateChain();
        }
        return null;
    }

    private KeyInfo(Vector keyNameVector, Vector keyValueVector, Vector retrievalMethodVector, Vector x509DataVector, Vector pgpDataVector, Vector spkiDataVector, Vector mgmtDataVector) {
        if (keyNameVector != null && keyNameVector.size() > 0) {
            this.keyName = new KeyName[keyNameVector.size()];
            keyNameVector.copyInto(this.keyName);
        }
        if (keyValueVector != null && keyValueVector.size() > 0) {
            this.keyValue = new KeyValue[keyValueVector.size()];
            keyValueVector.copyInto(this.keyValue);
        }
        if (x509DataVector != null && x509DataVector.size() > 0) {
            this.x509Data = new X509Data[x509DataVector.size()];
            x509DataVector.copyInto(this.x509Data);
        }
    }

    public ElementExtension getExtension() {
        return this.extension;
    }

    public void setExtension(ElementExtension extension) {
        this.extension = extension;
    }

    public void explodeCertificate() {
        X509Certificate cert = this.getCertificate();
        if (cert == null) {
            return;
        }
        this.keyName = new KeyName[1];
        this.keyName[0] = new KeyName("Public key of certificate");
        this.keyValue = new KeyValue[1];
        this.keyValue[0] = new KeyValue(cert.getPublicKey());
    }

    public String toString() {
        int i;
        String s = "[KeyInfo";
        if (this.keyName != null) {
            for (i = 0; i < this.keyName.length; ++i) {
                s = s + this.keyName[i];
            }
        }
        if (this.keyValue != null) {
            for (i = 0; i < this.keyValue.length; ++i) {
                s = s + this.keyValue[i];
            }
        }
        if (this.x509Data != null) {
            for (i = 0; i < this.x509Data.length; ++i) {
                s = s + this.x509Data[i];
            }
        }
        if (this.extension != null) {
            s = s + this.extension;
        }
        return s + "]";
    }

    public void toXml(DOMWriteCursor wc) {
        this.toXml(wc, false);
    }

    public DOMWriteCursor toXml(DOMWriteCursor wc, boolean insertBefore) {
        int i;
        if (this.keyName == null && this.keyValue == null && this.x509Data == null && this.extension == null) {
            return null;
        }
        wc = insertBefore ? wc.addBefore(uri, prefix, name) : wc.addUnder(uri, prefix, name);
        if (this.keyName != null) {
            for (i = 0; i < this.keyName.length; ++i) {
                this.keyName[i].toXml(wc);
            }
        }
        if (this.keyValue != null) {
            for (i = 0; i < this.keyValue.length; ++i) {
                this.keyValue[i].toXml(wc);
            }
        }
        if (this.x509Data != null) {
            for (i = 0; i < this.x509Data.length; ++i) {
                this.x509Data[i].toXml(wc);
            }
        }
        if (this.extension != null) {
            this.extension.toXml(wc);
        }
        return wc;
    }

    public static KeyInfo fromXml(DOMCursor cursor) throws ElementException {
        return KeyInfo.fromXml(cursor, null);
    }

    public static KeyInfo fromXml(DOMCursor cursor, ElementExtension ext) throws ElementException {
        DOMCursor cc = null;
        try {
            cc = KeyInfo.placeCursor(cursor, name, prefix, uri, ns);
        }
        catch (IllegalArgumentException e) {
            return new KeyInfo();
        }
        Vector<KeyName> keyNameVector = new Vector<KeyName>();
        DOMCursor c = cc.cloneCursor();
        boolean more = c.moveToChild(KeyName.uri, KeyName.name);
        while (more) {
            keyNameVector.add(KeyName.fromXml(c));
            more = c.moveToSibling(KeyName.uri, KeyName.name);
        }
        Vector<KeyValue> keyValueVector = new Vector<KeyValue>();
        c = cc.cloneCursor();
        more = c.moveToChild(KeyValue.uri, KeyValue.name);
        while (more) {
            keyValueVector.add(KeyValue.fromXml(c));
            more = c.moveToSibling(KeyValue.uri, KeyValue.name);
        }
        Vector<X509Data> x509DataVector = new Vector<X509Data>();
        c = cc.cloneCursor();
        more = c.moveToChild(X509Data.uri, X509Data.name);
        while (more) {
            x509DataVector.add(X509Data.fromXml(c));
            more = c.moveToSibling(X509Data.uri, X509Data.name);
        }
        KeyInfo ki = new KeyInfo(keyNameVector, keyValueVector, null, x509DataVector, null, null, null);
        if (ext != null) {
            ElementExtension e = ext.fromXml(cc);
            ki.setExtension(e);
        }
        return ki;
    }

    public static boolean isAnElementIn(DOMCursor cursor) {
        try {
            DOMCursor c = KeyInfo.placeCursor(cursor, name, prefix, uri, ns);
            return true;
        }
        catch (IllegalArgumentException e) {
            log.debug(e.toString());
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

