/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlenc.elements;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.apache.tsik.datatypes.Base64;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementException;
import org.apache.tsik.domutil.elements.ElementExtension;
import org.apache.tsik.domutil.elements.ElementImpl;
import org.apache.tsik.util.Namespaces;
import org.apache.tsik.xmlenc.AlgorithmType;
import org.apache.tsik.xmlenc.elements.CipherData;
import org.apache.tsik.xmlenc.elements.EncryptionMethod;
import org.apache.tsik.xmlsig.elements.KeyInfo;

public class EncryptedKey
extends ElementImpl
implements ElementExtension {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$tsik$xmlenc$elements$EncryptedKey == null ? (class$org$apache$tsik$xmlenc$elements$EncryptedKey = EncryptedKey.class$("org.apache.tsik.xmlenc.elements.EncryptedKey")) : class$org$apache$tsik$xmlenc$elements$EncryptedKey);
    static EncryptedKey INSTANCE = new EncryptedKey();
    private static String name = "EncryptedKey";
    private static String prefix = Namespaces.XMLENC.getPrefix();
    private static String uri = Namespaces.XMLENC.getUri();
    private static String[] ns = new String[]{prefix, uri};
    private Key encryptionKey;
    private Key decryptionKey;
    private Key keyToEncrypt;
    private EncryptionMethod encryptionMethod;
    private KeyInfo keyInfo;
    private CipherData cipherData;
    static /* synthetic */ Class class$org$apache$tsik$xmlenc$elements$EncryptedKey;

    public EncryptedKey() {
        this.encryptionMethod = new EncryptionMethod();
        this.keyInfo = new KeyInfo();
        this.cipherData = new CipherData();
    }

    public EncryptedKey(EncryptionMethod encryptionMethod, KeyInfo keyInfo, CipherData cipherData) {
        this.encryptionMethod = encryptionMethod;
        this.keyInfo = keyInfo;
        this.cipherData = cipherData;
    }

    public void setEncryptionKey(Key encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public void setDecryptionKey(Key decryptionKey) {
        this.decryptionKey = decryptionKey;
    }

    public void setKeyToEncrypt(Key keyToEncrypt) {
        this.keyToEncrypt = keyToEncrypt;
    }

    public Key getDecryptedKey() {
        return this.keyToEncrypt;
    }

    public void setKeyInfo(org.apache.tsik.xmlsig.KeyInfo keyInfo) {
        this.keyInfo = new KeyInfo(keyInfo);
    }

    public org.apache.tsik.xmlsig.KeyInfo getKeyInfo() {
        if (this.keyInfo != null) {
            return this.keyInfo.getKeyInfo();
        }
        return null;
    }

    public void encrypt(AlgorithmType type, boolean useOldKeyEncryption) throws NoSuchAlgorithmException, IllegalArgumentException {
        String s;
        if (type != AlgorithmType.RSA1_5) {
            throw new IllegalArgumentException("AlgorithmType must be RSA1_5 for key encryption");
        }
        String cipher = type.getJceAlgorithm();
        try {
            byte[] dec = this.keyToEncrypt.getEncoded();
            Cipher c = EncryptedKey.getCipher(cipher, !useOldKeyEncryption, this.encryptionKey);
            if (log.isDebugEnabled()) {
                log.debug("Using cipher: " + c.getAlgorithm());
                log.debug("about to encrypt " + dec.length + " KEY bytes:\n" + new BigInteger(1, dec).toString(16));
            }
            c.init(1, this.encryptionKey);
            byte[] enc = c.doFinal(dec);
            if (log.isDebugEnabled()) {
                log.debug("encrypted " + enc.length + " KEY bytes:\n" + new BigInteger(1, enc).toString(16));
            }
            s = Base64.encode(enc);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Probable mismatch of key with algorithm: " + e);
        }
        this.encryptionMethod.setAlgorithmType(type);
        this.cipherData.setEncryptedValue(s);
    }

    private Key convertToKey(byte[] b) {
        return new SecretKeySpec(b, "DESede");
    }

    public void decrypt() throws NoSuchAlgorithmException {
        String msg = "Probable mismatch of key with algorithm: ";
        try {
            this.decrypt(true);
        }
        catch (BadPaddingException e) {
            try {
                this.decrypt(false);
            }
            catch (Exception e1) {
                throw new IllegalArgumentException("Probable mismatch of key with algorithm: " + e);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Probable mismatch of key with algorithm: " + e);
        }
    }

    private void decrypt(boolean useCorrectPadding) throws GeneralSecurityException {
        AlgorithmType type = this.encryptionMethod.getAlgorithmType();
        String cipher = type.getJceAlgorithm();
        if (log.isDebugEnabled()) {
            log.debug("Decrypting using cipher: " + cipher);
        }
        byte[] enc = Base64.decode(this.cipherData.getEncryptedValue());
        Cipher c = EncryptedKey.getCipher(cipher, useCorrectPadding, this.decryptionKey);
        if (log.isDebugEnabled()) {
            log.debug("Using cipher: " + c.getAlgorithm());
            log.debug("    provider: " + c.getProvider());
            log.debug("about to decrypt " + enc.length + " KEY bytes:\n" + new BigInteger(1, enc).toString(16));
        }
        c.init(2, this.decryptionKey);
        byte[] dec = c.doFinal(enc);
        if (log.isDebugEnabled()) {
            log.debug("decrypted " + dec.length + " KEY bytes:\n" + new BigInteger(1, dec).toString(16));
        }
        this.keyToEncrypt = this.convertToKey(dec);
    }

    private static boolean hasBouncyCastle() {
        return Security.getProvider("BC") != null;
    }

    private static boolean hasChrysalis() {
        return Security.getProvider("LunaJCEProvider") != null;
    }

    private static boolean installBouncyCastle() {
        try {
            if (!EncryptedKey.hasBouncyCastle()) {
                Class<?> cls = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                Security.insertProviderAt((Provider)cls.newInstance(), 2);
                return true;
            }
        }
        catch (ClassNotFoundException ignore) {
        }
        catch (IllegalAccessException ignore) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return false;
    }

    private static void removeBouncyCastle() {
        Security.removeProvider("BC");
    }

    public static Cipher getCipher(String alg, Key key) throws NoSuchAlgorithmException {
        return EncryptedKey.getCipher(alg, true, key);
    }

    private static Cipher getCipher(String alg, boolean useCorrectPadding, Key key) throws NoSuchAlgorithmException {
        boolean weInstalledBouncyCastle = false;
        try {
            if (!EncryptedKey.hasBouncyCastle()) {
                weInstalledBouncyCastle = EncryptedKey.installBouncyCastle();
            }
            if (useCorrectPadding && (EncryptedKey.hasBouncyCastle() || EncryptedKey.hasChrysalis()) && "RSA".equals(alg)) {
                alg = "RSA/ECB/PKCS1PADDING";
            }
            Cipher cipher = Cipher.getInstance(alg);
            return cipher;
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (NoSuchPaddingException e) {
            throw new NoSuchAlgorithmException(e.toString());
        }
        finally {
            if (weInstalledBouncyCastle) {
                EncryptedKey.removeBouncyCastle();
            }
        }
    }

    public ElementExtension fromXml(DOMCursor cursor) {
        try {
            if (cursor.moveToChild(uri, name)) {
                cursor.moveToParent();
                return EncryptedKey.fromXmlStatic(cursor);
            }
            return null;
        }
        catch (ElementException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public static EncryptedKey fromXmlStatic(DOMCursor c) throws ElementException {
        DOMCursor cc = c.cloneCursor();
        cc.moveToChild(uri, name);
        EncryptionMethod encryptionMethod = (EncryptionMethod)EncryptionMethod.fromXml(cc);
        KeyInfo keyInfo = null;
        if (KeyInfo.isAnElementIn(cc)) {
            keyInfo = KeyInfo.fromXml(cc);
        }
        CipherData cipherData = CipherData.fromXml(cc);
        return new EncryptedKey(encryptionMethod, keyInfo, cipherData);
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        this.encryptionMethod.toXml(wc);
        if (this.keyInfo != null) {
            this.keyInfo.toXml(wc);
        }
        this.cipherData.toXml(wc);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

