/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xml.schema.loader;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.tsik.xml.schema.Facet;
import org.apache.tsik.xml.schema.loader.SimpleTypeImpl;
import org.apache.tsik.xml.schema.loader.ValueType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class FacetImpl
implements Facet {
    protected short type;
    protected Object value;
    protected boolean isFixed;
    protected ValueType valueType;

    static FacetImpl newInstance(Element e, SimpleTypeImpl stype) {
        String schemaNS = stype.schema.NS_XS;
        String data = e.getAttribute("value");
        String name = SimpleTypeImpl.ops.getLocalName(e);
        boolean isFixed = "true".equals(e.getAttribute("fixed"));
        SimpleTypeImpl longType = (SimpleTypeImpl)stype.schema.getType(schemaNS, "long");
        ValueType valueType = stype.getValueType();
        try {
            if (name.equals("length")) {
                Object value = longType.valueOf(data);
                return new Length(value, isFixed, valueType);
            }
            if (name.equals("minLength")) {
                Object value = longType.valueOf(data);
                return new MinLength(value, isFixed, valueType);
            }
            if (name.equals("maxLength")) {
                Object value = longType.valueOf(data);
                return new MaxLength(value, isFixed, valueType);
            }
            if (name.equals("pattern")) {
                FacetImpl otherFacet = (FacetImpl)stype.getFacet((short)4, false);
                if (otherFacet != null) {
                    otherFacet.appendValue(data);
                    return null;
                }
                return new Pattern(data, isFixed);
            }
            if (name.equals("enumeration")) {
                Object value = FacetImpl.getBaseTypeValue(stype, data);
                FacetImpl otherFacet = (FacetImpl)stype.getFacet((short)5, false);
                if (otherFacet != null) {
                    otherFacet.appendValue(value);
                    return null;
                }
                return new Enumeration(value, isFixed, valueType);
            }
            if (name.equals("whiteSpace")) {
                int v;
                if ((data = SimpleTypeImpl.ops.collapseWhiteSpace(data)).equals("preserve")) {
                    v = 1;
                } else if (data.equals("replace")) {
                    v = 2;
                } else if (data.equals("preserve")) {
                    v = 3;
                } else {
                    throw new Error("invalid whiteSpace: " + data);
                }
                return new WhiteSpace((short)v, isFixed);
            }
            if (name.equals("maxInclusive")) {
                Object value = FacetImpl.getBaseTypeValue(stype, data);
                return new MaxInclusive(value, isFixed, valueType);
            }
            if (name.equals("maxExclusive")) {
                Object value = FacetImpl.getBaseTypeValue(stype, data);
                return new MaxExclusive(value, isFixed, valueType);
            }
            if (name.equals("minExclusive")) {
                Object value = FacetImpl.getBaseTypeValue(stype, data);
                return new MinExclusive(value, isFixed, valueType);
            }
            if (name.equals("minInclusive")) {
                Object value = FacetImpl.getBaseTypeValue(stype, data);
                return new MinInclusive(value, isFixed, valueType);
            }
            if (name.equals("precision") && schemaNS == "http://www.w3.org/2000/10/XMLSchema" || name.equals("totalDigits") && schemaNS == "http://www.w3.org/2001/XMLSchema") {
                Number longValue = (Number)longType.valueOf(data);
                return new Precision(longValue, isFixed, valueType);
            }
            if (name.equals("scale") && schemaNS == "http://www.w3.org/2000/10/XMLSchema" || name.equals("fractionDigits") && schemaNS == "http://www.w3.org/2001/XMLSchema") {
                Number longValue = (Number)longType.valueOf(data);
                return new Scale(longValue, isFixed, valueType);
            }
            if (name.equals("encoding") && schemaNS == "http://www.w3.org/2000/10/XMLSchema") {
                return new Encoding(data, isFixed);
            }
            throw new Error();
        }
        catch (Exception ex) {
            stype.schema.error(null, ex, (Node)e, null, null);
            return null;
        }
        catch (Error ex) {
            stype.schema.error(null, ex, (Node)e, null, null);
            return null;
        }
        catch (Throwable ex) {
            stype.schema.error(null, ex, (Node)e, null, null);
            return null;
        }
    }

    private static Object getBaseTypeValue(SimpleTypeImpl stype, String data) throws Exception {
        SimpleTypeImpl sbase = (SimpleTypeImpl)stype.getBaseType();
        if (stype.schema.NS_XS.equals(sbase.namespaceURI) && "binary".equals(sbase.localName)) {
            return stype.getValueType().valueOf(data);
        }
        return sbase.valueOf(data);
    }

    protected FacetImpl(short type, Object value, boolean isFixed, ValueType valueType) {
        this.type = type;
        this.value = value;
        this.isFixed = isFixed;
        this.valueType = valueType;
    }

    public short getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    boolean appendValue(Object newValue) {
        return false;
    }

    void bind() {
    }

    abstract void validate(String var1, Object var2) throws Exception;

    static class ValueHolder
    extends FacetImpl {
        ValueHolder(short type, Object value, boolean isFixed, ValueType valueType) {
            super(type, value, isFixed, valueType);
        }

        void validate(String testData, Object testValue) throws Exception {
        }
    }

    static class Encoding
    extends ValueHolder {
        Encoding(String value, boolean isFixed) {
            super((short)13, value, isFixed, ValueType.STRING);
        }
    }

    static class Scale
    extends FacetImpl {
        Scale(Number value, boolean isFixed, ValueType valueType) {
            super((short)12, value, isFixed, valueType);
        }

        void validate(String testData, Object testValue) throws Exception {
            if (this.valueType.getScale(testValue) != ((Number)this.value).intValue()) {
                throw new Exception("scale " + this.value);
            }
        }
    }

    static class Precision
    extends FacetImpl {
        Precision(Number value, boolean isFixed, ValueType valueType) {
            super((short)11, null, isFixed, valueType);
            BigInteger bint = BigInteger.valueOf(10L);
            this.value = bint.pow(value.intValue());
        }

        void validate(String testData, Object testValue) throws Exception {
            if (this.valueType.exceedsPrecision(testValue, (BigInteger)this.value)) {
                throw new Exception("precision " + this.value);
            }
        }
    }

    static class MinInclusive
    extends FacetImpl {
        MinInclusive(Object value, boolean isFixed, ValueType valueType) {
            super((short)9, value, isFixed, valueType);
        }

        void validate(String testData, Object testValue) throws Exception {
            if (((Comparable)this.value).compareTo(testValue) > 0) {
                throw new Exception("minInclusive " + this.value);
            }
        }
    }

    static class MinExclusive
    extends FacetImpl {
        MinExclusive(Object value, boolean isFixed, ValueType valueType) {
            super((short)10, value, isFixed, valueType);
        }

        void validate(String testData, Object testValue) throws Exception {
            if (((Comparable)this.value).compareTo(testValue) >= 0) {
                throw new Exception("minExclusive " + this.value);
            }
        }
    }

    static class MaxExclusive
    extends FacetImpl {
        MaxExclusive(Object value, boolean isFixed, ValueType valueType) {
            super((short)8, value, isFixed, valueType);
        }

        void validate(String testData, Object testValue) throws Exception {
            if (((Comparable)this.value).compareTo(testValue) <= 0) {
                throw new Exception("maxExclusive " + this.value);
            }
        }
    }

    static class MaxInclusive
    extends FacetImpl {
        MaxInclusive(Object value, boolean isFixed, ValueType valueType) {
            super((short)7, value, isFixed, valueType);
        }

        void validate(String testData, Object testValue) throws Exception {
            if (((Comparable)this.value).compareTo(testValue) < 0) {
                throw new Exception("maxInclusive " + this.value);
            }
        }
    }

    static class WhiteSpace
    extends ValueHolder {
        WhiteSpace(short value, boolean isFixed) {
            super((short)6, BigInteger.valueOf(value), isFixed, ValueType.INTEGER);
        }
    }

    static class Enumeration
    extends FacetImpl {
        Enumeration(Object value, boolean isFixed, ValueType valueType) {
            super((short)5, new ArrayList(), isFixed, valueType);
            this.appendValue(value);
        }

        boolean appendValue(Object newValue) {
            ((List)this.value).add(newValue);
            return true;
        }

        void validate(String testData, Object testValue) throws Exception {
            List list = (List)this.value;
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                if (!testValue.equals(list.get(i))) continue;
                return;
            }
            throw new Exception("enumeration " + this.value);
        }
    }

    static class Pattern
    extends FacetImpl {
        Pattern(String value, boolean isFixed) {
            super((short)4, value, isFixed, ValueType.STRING);
        }

        boolean appendValue(Object newValue) {
            this.value = (String)this.value + '|' + newValue;
            return true;
        }

        void bind() {
        }

        void validate(String testData, Object testValue) throws Exception {
        }
    }

    static class MaxLength
    extends FacetImpl {
        MaxLength(Object value, boolean isFixed, ValueType valueType) {
            super((short)3, value, isFixed, valueType);
        }

        void validate(String testData, Object testValue) throws Exception {
            if (this.valueType.length(testValue) > ((Number)this.value).longValue()) {
                throw new Exception("maxLength " + this.value);
            }
        }
    }

    static class MinLength
    extends FacetImpl {
        MinLength(Object value, boolean isFixed, ValueType valueType) {
            super((short)2, value, isFixed, valueType);
        }

        void validate(String testData, Object testValue) throws Exception {
            if (this.valueType.length(testValue) < ((Number)this.value).longValue()) {
                throw new Exception("minLength " + this.value);
            }
        }
    }

    static class Length
    extends FacetImpl {
        Length(Object value, boolean isFixed, ValueType valueType) {
            super((short)1, value, isFixed, valueType);
        }

        void validate(String testData, Object testValue) throws Exception {
            if (this.valueType.length(testValue) != ((Number)this.value).longValue()) {
                throw new Exception("length " + this.value);
            }
        }
    }
}

