/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.wss.actions;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.Collections;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.util.Namespaces;
import org.apache.tsik.wsp.Action;
import org.apache.tsik.wsp.ActionViolation;
import org.apache.tsik.wss.Id;
import org.apache.tsik.wss.elements.KeyInfo;
import org.apache.tsik.wss.elements.SecurityTokenReference;
import org.apache.tsik.wss.elements.Signature;
import org.apache.tsik.xmlsig.Signer;
import org.apache.tsik.xpath.XPath;

public class SignBody
extends Action {
    PrivateKey key;
    XPath sigOutput;
    String tokenId;

    private boolean checkPreconditions() {
        this.key = this.getPrivateKey("key");
        this.sigOutput = this.getXPath("sigoutput");
        this.tokenId = this.getString("tokenid");
        if (this.key == null || this.sigOutput == null || this.tokenId == null) {
            return false;
        }
        return this.moveOutputToXPath(this.sigOutput);
    }

    public void execute() {
        if (!this.checkPreconditions()) {
            this.violations.add(new ActionViolation("Precond check failed"));
            return;
        }
        DOMWriteCursor tmp = this.output.cloneWriteCursor();
        String[] ns = new String[]{"s", Namespaces.SOAPENV.getUri()};
        String s = "/s:Envelope/s:Body";
        tmp.moveToXPath(new XPath(s, ns));
        String id = Id.getId(tmp);
        if (id == null) {
            id = Id.generateId();
            Id.insertInto(tmp, id);
        }
        try {
            Signer signer = new Signer(this.output.getDocument(), this.key);
            signer.useExclusiveCanonicalizer(Collections.EMPTY_LIST);
            signer.addReference(XPath.fromID(id));
            signer.signInPlace(this.sigOutput);
        }
        catch (NoSuchAlgorithmException e) {
            this.violations.add(new ActionViolation((Exception)e));
            return;
        }
        catch (InvalidKeyException e) {
            this.violations.add(new ActionViolation((Exception)e));
            return;
        }
        catch (SignatureException e) {
            this.violations.add(new ActionViolation((Exception)e));
            return;
        }
        SecurityTokenReference str = new SecurityTokenReference(this.tokenId);
        this.output.moveToXPath(this.sigOutput);
        this.output.moveToChild(Signature.uri, Signature.elementName);
        this.output = this.output.addUnder(KeyInfo.uri, KeyInfo.prefix, KeyInfo.elementName);
        str.toXml(this.output);
    }

    public boolean needsOutputDocument() {
        return true;
    }
}

