/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.wss;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementImpl;
import org.apache.tsik.plugins.SoapEngine;
import org.apache.tsik.plugins.SoapFactory;
import org.apache.tsik.plugins.SoapFault;
import org.apache.tsik.plugins.SoapFaultConstants;
import org.apache.tsik.plugins.SoapMessage;
import org.apache.tsik.wss.Id;
import org.apache.tsik.wss.TokenResolver;
import org.apache.tsik.wss.elements.BinarySecurityToken;
import org.apache.tsik.wss.elements.EncryptedData;
import org.apache.tsik.wss.elements.EncryptedKey;
import org.apache.tsik.wss.elements.KeyInfo;
import org.apache.tsik.wss.elements.Security;
import org.apache.tsik.wss.elements.SecurityTokenReference;
import org.apache.tsik.wss.elements.Signature;
import org.apache.tsik.wss.elements.SoapHeaderWrapper;
import org.apache.tsik.xmlsig.Signer;
import org.apache.tsik.xpath.XPath;
import org.apache.tsik.xpath.XPathException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Wss {
    private Logger log = LoggerFactory.getLogger(class$org$apache$tsik$wss$Wss == null ? (class$org$apache$tsik$wss$Wss = Wss.class$("org.apache.tsik.wss.Wss")) : class$org$apache$tsik$wss$Wss);
    private SoapEngine soapEngine = SoapFactory.getDefaultEngine();
    private List headers;
    private SoapMessage soap;
    static /* synthetic */ Class class$org$apache$tsik$wss$Wss;

    public Wss(SoapMessage soap) {
        this.soap = soap;
        this.headers = new ArrayList();
        if (soap != null) {
            Element[] h = soap.getHeaders();
            for (int i = 0; i < h.length; ++i) {
                DOMCursor c = new DOMCursor(h[i]);
                if (c.atElement(Security.uri, Security.elementName)) {
                    try {
                        Security s = Security.fromXmlMustUnderstand(soap.getMustUnderstand(h[i]), new DOMCursor(h[i]));
                        this.headers.add(s);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new IllegalArgumentException(e.toString());
                    }
                }
                SoapHeaderWrapper shw = new SoapHeaderWrapper(h[i]);
                this.headers.add(shw);
            }
        }
    }

    public void addSecurity(Security security) {
        this.headers.add(security);
    }

    public Security getSecurity() {
        return this.getSecurity(0);
    }

    public Security getSecurity(int n) {
        if (this.headers == null) {
            return null;
        }
        int size = this.headers.size();
        for (int i = 0; i < size; ++i) {
            ElementImpl e = (ElementImpl)this.headers.get(i);
            if (i != n || !(e instanceof Security)) continue;
            return (Security)e;
        }
        return null;
    }

    public int numberOfSecurityHeaders() {
        if (this.headers == null) {
            return 0;
        }
        int size = this.headers.size();
        int num = 0;
        for (int i = 0; i < size; ++i) {
            ElementImpl e = (ElementImpl)this.headers.get(i);
            if (!(e instanceof Security)) continue;
            ++num;
        }
        return num;
    }

    public SoapMessage toSoapMessage() {
        int i;
        ElementImpl[] h = new ElementImpl[this.headers.size()];
        this.headers.toArray(h);
        Element[] elems = new Element[h.length];
        for (i = 0; i < h.length; ++i) {
            DOMWriteCursor wc = new DOMWriteCursor();
            h[i].toXml(wc);
            elems[i] = wc.getElement();
        }
        for (i = 0; i < h.length; ++i) {
            if (!(h[i] instanceof Security) || !((Security)h[i]).getMustUnderstand()) continue;
            this.soap.setMustUnderstand(elems[i], true);
        }
        this.soap.setHeaders(elems);
        return this.soap;
    }

    public String toString() {
        String s = "[Wss ";
        int len = this.headers.size();
        for (int i = 0; i < len; ++i) {
            s = s + "{header " + i + ":" + this.headers.get(i) + "}";
        }
        return s + "]";
    }

    public SoapFault process(Security security, TokenResolver resolver) {
        try {
            security.process(this.soap, resolver);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            return this.soapEngine.getSoapFaultInstance(SoapFaultConstants.SERVER, stringWriter.toString(), "actor", null);
        }
    }

    public Signature signBody(Security security, String bstId, SecurityTokenReference str, PrivateKey key, ElementImpl[] toSign, String[] toSignId) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, CertificateException, XPathException {
        ElementImpl ei = security.getElement(bstId);
        if (!(ei instanceof BinarySecurityToken)) {
            throw new IllegalArgumentException(bstId + " is not a BinarySecurityToken");
        }
        Element elem = this.soap.getBody();
        DOMWriteCursor wc = new DOMWriteCursor(elem);
        wc.moveToParent();
        String id = wc.getAttribute("Id");
        if (id == null) {
            id = Id.getId(wc);
        }
        if (id == null) {
            id = Id.generateId();
            Id.insertInto(wc, id);
        }
        Document doc = this.soap.getDocument();
        DOMWriteCursor origSoapCursor = new DOMWriteCursor(doc);
        DOMWriteCursor temp = new DOMWriteCursor();
        temp.copyUnder(origSoapCursor);
        if (toSign != null) {
            for (int i = 0; i < toSign.length; ++i) {
                DOMWriteCursor c = new DOMWriteCursor();
                toSign[i].toXml(c);
                Id.insertInto(c, toSignId[i]);
                temp.copyUnder(c);
            }
        }
        SoapMessage soapCopy = this.soapEngine.getSoapMessageInstance(temp.getDocument());
        doc = soapCopy.getDocument();
        org.apache.tsik.xmlsig.KeyInfo ki = new org.apache.tsik.xmlsig.KeyInfo();
        Signer signer = new Signer(doc, key, ki);
        signer.useExclusiveCanonicalizer(Collections.EMPTY_LIST);
        signer.addReference(XPath.fromID(id));
        if (toSign != null) {
            for (int i = 0; i < toSign.length; ++i) {
                signer.addReference(XPath.fromID(toSignId[i]));
            }
        }
        doc = signer.sign(new XPath("/"));
        DOMCursor c = new DOMCursor(doc);
        Signature sig = Signature.fromXml(c);
        KeyInfo keyInfo = new KeyInfo(str);
        sig.setKeyInfo(keyInfo);
        return sig;
    }

    public void encryptBody(Security security, EncryptedKey ek, String encId) throws NoSuchAlgorithmException {
        Element elem = this.soap.getBody();
        DOMWriteCursor c = new DOMWriteCursor(elem);
        c.moveToParent();
        DOMWriteCursor wc = new DOMWriteCursor();
        wc.copyUnder(c);
        EncryptedData ed = security.encryptData(ek, encId, wc, true);
        wc = new DOMWriteCursor();
        ed.toXml(wc);
        elem = this.soap.getBody();
        c = new DOMWriteCursor(elem);
        c.copyOver(wc);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

