/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.c14n;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tsik.c14n.AbstractCanonicalizer;
import org.apache.tsik.c14n.AttributeComparator;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class ExclusiveCanonicalizer
extends AbstractCanonicalizer {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$tsik$c14n$ExclusiveCanonicalizer == null ? (class$org$apache$tsik$c14n$ExclusiveCanonicalizer = ExclusiveCanonicalizer.class$("org.apache.tsik.c14n.ExclusiveCanonicalizer")) : class$org$apache$tsik$c14n$ExclusiveCanonicalizer);
    private List prefixList = new ArrayList();
    private HashMap ancestralNamespaces = new HashMap();
    private List namespaceStack = new ArrayList();
    static /* synthetic */ Class class$org$apache$tsik$c14n$ExclusiveCanonicalizer;

    ExclusiveCanonicalizer(boolean useComments) {
        super(useComments);
    }

    void handleAncestralNamespaces(Node node, Map namespaces) {
        this.ancestralNamespaces.putAll(namespaces);
    }

    boolean shouldAncestralAttributeBeAdded(Attr attribute, Node node) {
        String s = ops.getLocalName(attribute);
        if ("xmlns".equals(s)) {
            return true;
        }
        return this.prefixList.contains(s);
    }

    public void setInclusivePrefixList(List list) {
        if (list == null) {
            throw new IllegalArgumentException("prefix cannot be null");
        }
        this.prefixList = list;
    }

    void beforeElement(Node node) {
        Attr attr;
        int i;
        int len;
        log.debug("Add visibly used namespaces for node" + node);
        ArrayList<String> visiblePrefixes = new ArrayList<String>();
        String elemPrefix = ops.getPrefix(node);
        if (elemPrefix == null) {
            elemPrefix = "xmlns";
        }
        log.debug("Add " + elemPrefix + " to list");
        visiblePrefixes.add(elemPrefix);
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            len = attrs.getLength();
            for (i = 0; i < len; ++i) {
                String attrPrefix;
                attr = (Attr)attrs.item(i);
                if (AttributeComparator.isNamespaceAttr(attr) || (attrPrefix = ops.getPrefix(attr)) == null) continue;
                log.debug("Add " + attrPrefix + " to list");
                visiblePrefixes.add(attrPrefix);
            }
        }
        this.namespaceStack.add(this.ancestralNamespaces);
        this.ancestralNamespaces = (HashMap)this.ancestralNamespaces.clone();
        if (attrs != null) {
            len = attrs.getLength();
            for (i = 0; i < len; ++i) {
                attr = (Attr)attrs.item(i);
                if (attr == null || !AttributeComparator.isNamespaceAttr(attr)) continue;
                String nsPrefix = ops.getLocalName(attr);
                this.ancestralNamespaces.put(nsPrefix, attr);
                if (this.prefixList.contains(nsPrefix) || visiblePrefixes.contains(nsPrefix)) continue;
                log.debug("Removing namespace " + nsPrefix);
                ((Element)node).removeAttributeNode(attr);
                --i;
            }
        }
        Iterator iter = this.ancestralNamespaces.values().iterator();
        while (iter.hasNext()) {
            Attr attr2 = (Attr)iter.next();
            String nsPrefix = ops.getLocalName(attr2);
            if (!this.prefixList.contains(nsPrefix) && !visiblePrefixes.contains(nsPrefix)) continue;
            log.debug("Adding namespace " + nsPrefix);
            ((Element)node).setAttributeNS(ops.getNamespaceURI(attr2), attr2.getName(), attr2.getValue());
        }
    }

    void afterElement(Node node) {
        this.ancestralNamespaces = (HashMap)this.namespaceStack.remove(this.namespaceStack.size() - 1);
    }

    protected Node removeExtraNamespaces(Node node, Node topNode) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return node;
        }
        int len = attrs.getLength();
        for (int i = 0; i < len; ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr == null) continue;
            String value = attr.getValue();
            if (!AttributeComparator.isNamespaceAttr(attr)) continue;
            Node parent = node.getParentNode();
            while (parent != null) {
                Attr parentAttr = ((Element)parent).getAttributeNode(attr.getName());
                if (parentAttr != null) {
                    if (parentAttr.getValue().equals(value)) {
                        ((Element)node).removeAttributeNode(attr);
                        --i;
                    }
                    parent = null;
                    continue;
                }
                if (parent == topNode) {
                    parent = null;
                    continue;
                }
                parent = parent.getParentNode();
            }
        }
        return node;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

