/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider;

import java.util.ArrayList;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.metadata.FieldColumnMapper;
import org.dromara.mybatis.jpa.metadata.MapperMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicDeleteProvider<T extends JpaEntity> {
    private static final Logger logger = LoggerFactory.getLogger(LogicDeleteProvider.class);

    public String logicDelete(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get("entityClass");
        MapperMetadata.buildColumnList(entityClass);
        String tableName = MapperMetadata.getTableName(entityClass);
        ArrayList idValues = (ArrayList)parametersMap.get("idList");
        StringBuffer keyValue = new StringBuffer();
        for (String value : idValues) {
            if (value.trim().length() <= 0) continue;
            keyValue.append(",'").append(value).append("'");
            logger.trace("logic delete by id {}", (Object)value);
        }
        String keyValues = keyValue.substring(1).replaceAll(";", "");
        FieldColumnMapper logicColumnMapper = MapperMetadata.getLogicColumn(entityClass.getSimpleName());
        String partitionKeyValue = (String)parametersMap.get("partitionKey");
        FieldColumnMapper partitionKeyColumnMapper = MapperMetadata.getPartitionKey(entityClass.getSimpleName());
        FieldColumnMapper idFieldColumnMapper = MapperMetadata.getIdColumn(entityClass.getSimpleName());
        SQL sql = (SQL)((SQL)new SQL().UPDATE(tableName)).SET(" %s = %s ".formatted(logicColumnMapper.getColumnName(), logicColumnMapper.getColumnLogic().delete()));
        if (partitionKeyColumnMapper != null && partitionKeyValue != null) {
            sql.WHERE("%s = #{%s} and %s  in ( %s )".formatted(partitionKeyColumnMapper.getColumnName(), partitionKeyValue, idFieldColumnMapper.getColumnName(), idFieldColumnMapper.getFieldName()));
        } else {
            sql.WHERE(" %s in ( %s )".formatted(idFieldColumnMapper.getColumnName(), keyValues));
        }
        String deleteSql = sql.toString();
        MapperMetadata.sqlsMap.put(String.valueOf(tableName) + "_LOGICDELETE_SQL", deleteSql);
        logger.trace("logic Delete SQL \n{}", (Object)deleteSql);
        return deleteSql;
    }
}

