/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.client.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.maxkey.client.oauth.exceptions.OAuthException;
import org.maxkey.client.utils.Preconditions;

public abstract class HttpEncoder {
    private static final String CHARSET = "UTF-8";
    private static final Map<String, String> ENCODING_RULES;

    static {
        HashMap<String, String> rules = new HashMap<String, String>();
        rules.put("*", "%2A");
        rules.put("+", "%20");
        rules.put("%7E", "~");
        ENCODING_RULES = Collections.unmodifiableMap(rules);
    }

    public static String encode(String plain) {
        String encoded;
        Preconditions.checkNotNull(plain, "Cannot encode null object");
        try {
            encoded = URLEncoder.encode(plain, CHARSET);
        }
        catch (UnsupportedEncodingException uee) {
            throw new OAuthException("Charset not found while encoding string: UTF-8", uee);
        }
        for (Map.Entry<String, String> rule : ENCODING_RULES.entrySet()) {
            encoded = HttpEncoder.applyRule(encoded, rule.getKey(), rule.getValue());
        }
        return encoded;
    }

    private static String applyRule(String encoded, String toReplace, String replacement) {
        return encoded.replaceAll(Pattern.quote(toReplace), replacement);
    }

    public static String decode(String encoded) throws UnsupportedEncodingException {
        Preconditions.checkNotNull(encoded, "Cannot decode null object");
        return URLDecoder.decode(encoded, CHARSET);
    }
}

