/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.interceptor.builder;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.jdbc.SQL;
import org.apache.ibatis.mapping.BoundSql;
import org.dromara.mybatis.jpa.metadata.FieldColumnMapper;
import org.dromara.mybatis.jpa.metadata.FieldMetadata;
import org.dromara.mybatis.jpa.metadata.TableMetadata;
import org.dromara.mybatis.jpa.metadata.findby.FindByKeywords;
import org.dromara.mybatis.jpa.metadata.findby.FindByMapper;
import org.dromara.mybatis.jpa.metadata.findby.FindByMetadata;
import org.dromara.mybatis.jpa.query.Query;
import org.dromara.mybatis.jpa.query.builder.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindBySqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(FindBySqlBuilder.class);

    public static boolean isFindBy(String mappedStatementId, BoundSql boundSql) {
        return StringUtils.isBlank((CharSequence)boundSql.getSql()) && !FindByMetadata.containsKey(mappedStatementId);
    }

    public static void parse(String mappedStatementId, BoundSql boundSql) {
        if (FindBySqlBuilder.isFindBy(mappedStatementId, boundSql)) {
            FindByMapper findByMapper = new FindByMapper(mappedStatementId);
            findByMapper.parseFindBy();
            FindByMetadata.put(mappedStatementId, findByMapper);
        }
    }

    public static String translate(FindByMapper findByMapper, Object parameterObject) {
        findByMapper.parseEntityClass();
        List<FieldColumnMapper> entityFields = FieldMetadata.buildColumnMapper(findByMapper.getEntityClass());
        Query q = Query.builder();
        String fieldNameStart = findByMapper.getRemovedFindByName();
        int argIndex = 0;
        for (FieldColumnMapper fcm : entityFields) {
            String fieldName = fcm.getFieldName();
            String columnName = fcm.getColumnName();
            String findByKeyword = "";
            String capitalizeFieldName = StringUtils.capitalize((String)fieldName);
            if (fieldNameStart.startsWith(capitalizeFieldName)) {
                logger.trace("FieldName : {} , capitalize {}", (Object)fieldName, (Object)capitalizeFieldName);
                if (fieldNameStart.length() >= fieldName.length()) {
                    findByKeyword = FindByKeywords.startKeyword(fieldNameStart = fieldNameStart.substring(fieldName.length()));
                    if (StringUtils.isNotBlank((CharSequence)findByKeyword) && !"OrderBy".equals(findByKeyword)) {
                        fieldNameStart = fieldNameStart.substring(findByKeyword.length());
                    }
                    logger.trace("FindBy fieldNameStart : {} ", (Object)fieldNameStart);
                    if (StringUtils.isBlank((CharSequence)findByKeyword)) {
                        findByKeyword = "Equals";
                    }
                    logger.trace("FindBy Keyword : {} ", (Object)findByKeyword);
                }
                if ("Between".equals(findByKeyword)) {
                    FindBySqlBuilder.appendParameter(q, findByKeyword, columnName, ((MapperMethod.ParamMap)parameterObject).get((Object)"arg0"), ((MapperMethod.ParamMap)parameterObject).get((Object)"arg1"));
                    break;
                }
                if (parameterObject instanceof MapperMethod.ParamMap) {
                    MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)parameterObject;
                    Object parameterValue = paramMap.get((Object)("arg" + argIndex++));
                    logger.trace("FindBy getCanonicalName : {} ", (Object)parameterValue.getClass().getCanonicalName());
                    if ("And".equals(findByKeyword)) {
                        FindBySqlBuilder.appendParameter(q, "Equals", columnName, parameterValue, null);
                        FindBySqlBuilder.appendParameter(q, "And", columnName, parameterValue, null);
                    } else if ("Or".equals(findByKeyword)) {
                        FindBySqlBuilder.appendParameter(q, "Equals", columnName, parameterValue, null);
                        FindBySqlBuilder.appendParameter(q, "Or", columnName, parameterValue, null);
                    } else {
                        FindBySqlBuilder.appendParameter(q, findByKeyword, columnName, parameterValue, null);
                    }
                } else if ("OrderBy".equals(findByKeyword)) {
                    FindBySqlBuilder.appendParameter(q, "Equals", columnName, parameterObject, null);
                } else {
                    FindBySqlBuilder.appendParameter(q, findByKeyword, columnName, parameterObject, null);
                }
                if (fieldNameStart.length() >= fieldName.length() && !StringUtils.isBlank((CharSequence)fieldNameStart)) continue;
                logger.trace("FindBy break");
                break;
            }
            findByKeyword = FindByKeywords.startKeyword(fieldNameStart);
            if (!StringUtils.isNotBlank((CharSequence)findByKeyword) || !"OrderBy".equals(findByKeyword)) continue;
            logger.trace("FindBy Keyword : {} ", (Object)findByKeyword);
            fieldNameStart = fieldNameStart.substring(findByKeyword.length());
            logger.trace("FindBy order by columnName : {} ", (Object)fieldNameStart);
            String orderBy = "asc";
            if (fieldNameStart.endsWith("Desc")) {
                orderBy = "desc";
            }
            columnName = FindBySqlBuilder.getColumnNameFromEntityFields(entityFields, fieldNameStart);
            FindBySqlBuilder.appendParameter(q, "OrderBy", columnName, orderBy, null);
            break;
        }
        logger.trace("Query : {}", (Object)q);
        SQL selectSql = TableMetadata.buildSelect(findByMapper.getEntityClass(), findByMapper.isDistinct());
        selectSql.WHERE("( " + QueryBuilder.build(q) + " )");
        FieldColumnMapper logicColumnMapper = FieldMetadata.getLogicColumn(findByMapper.getEntityClass());
        if (logicColumnMapper != null && logicColumnMapper.isLogicDelete()) {
            selectSql.WHERE(" %s = '%s'".formatted(logicColumnMapper.getColumnName(), logicColumnMapper.getSoftDelete().value()));
        }
        if (q.getOrderBy() != null) {
            selectSql.ORDER_BY(QueryBuilder.buildOrderBy(q));
        }
        logger.trace("selectSql : \n{}", (Object)selectSql);
        return selectSql.toString();
    }

    public static String getColumnNameFromEntityFields(List<FieldColumnMapper> entityFields, String fieldNameStart) {
        String columnName = "";
        for (FieldColumnMapper fcm : entityFields) {
            String fieldName = fcm.getFieldName();
            if (!fieldNameStart.startsWith(StringUtils.capitalize((String)fieldName))) continue;
            columnName = fcm.getColumnName();
            break;
        }
        return columnName;
    }

    protected static void appendParameter(Query q, String operator, String columnName, Object value, Object value1) {
        if ("And".equals(operator)) {
            q.and();
        } else if ("Or".equals(operator)) {
            q.or();
        } else if ("Is".equals(operator) || "Equals".equals(operator)) {
            q.eq(columnName, value);
        } else if ("Between".equals(operator)) {
            q.between(columnName, value, value1);
        } else if ("LessThan".equals(operator) || "Before".equals(operator)) {
            q.lt(columnName, value);
        } else if ("LessThanEqual".equals(operator)) {
            q.le(columnName, value);
        } else if ("GreaterThan".equals(operator) || "After".equals(operator)) {
            q.gt(columnName, value);
        } else if ("GreaterThanEqual".equals(operator)) {
            q.ge(columnName, value);
        } else if ("IsNull".equals(operator) || "Null".equals(operator)) {
            q.isNull(columnName);
        } else if ("IsNotNull".equals(operator) || "NotNull".equals(operator)) {
            q.isNotNull(columnName);
        } else if ("Like".equals(operator)) {
            q.like(columnName, value);
        } else if ("NotLike".equals(operator)) {
            q.notLike(columnName, value);
        } else if ("StartingWith".equals(operator)) {
            q.likeRight(columnName, value);
        } else if ("EndingWith".equals(operator)) {
            q.likeLeft(columnName, value);
        } else if ("Containing".equals(operator)) {
            q.like(columnName, value);
        } else if ("OrderBy".equals(operator)) {
            q.orderBy(columnName, value.toString());
        } else if ("Not".equals(operator)) {
            q.notEq(columnName, value);
        } else if ("In".equals(operator)) {
            q.in(columnName, value);
        } else if ("NotIn".equals(operator)) {
            q.notIn(columnName, value);
        } else if ("True".equals(operator)) {
            q.eq(columnName, true);
        } else if ("False".equals(operator)) {
            q.eq(columnName, false);
        } else if ("IgnoreCase".equals(operator)) {
            q.ignoreCase(columnName, value);
        }
    }
}

