/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.persistence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.mybatis.jpa.PageResultsSqlCache;
import org.apache.mybatis.jpa.persistence.IJpaBaseMapper;
import org.apache.mybatis.jpa.persistence.JpaBaseEntity;
import org.apache.mybatis.jpa.persistence.JpaPageResults;
import org.apache.mybatis.jpa.persistence.JpaPagination;
import org.apache.mybatis.jpa.util.BeanUtil;
import org.apache.mybatis.jpa.util.InstanceUtil;
import org.apache.mybatis.jpa.util.WebContext;
import org.ehcache.UserManagedCache;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.builders.UserManagedCacheBuilder;

public class JpaBaseService<T extends JpaBaseEntity> {
    static final Logger _logger = Logger.getLogger(JpaBaseService.class);
    @JsonIgnore
    public static UserManagedCache<String, PageResultsSqlCache> pageResultsBoundSqlCache = UserManagedCacheBuilder.newUserManagedCacheBuilder(String.class, PageResultsSqlCache.class).withResourcePools(ResourcePoolsBuilder.heap((long)1000L)).withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofSeconds(300L))).build(true);
    @JsonIgnore
    private String mapperClass = "";
    @JsonIgnore
    private Class entityClass;
    @JsonIgnore
    private IJpaBaseMapper<T> mapper = null;

    public JpaBaseService() {
    }

    public JpaBaseService(Class cls) {
        _logger.trace((Object)("class : " + cls.getSimpleName()));
        this.mapperClass = cls.getSimpleName();
        Type[] pType = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        if (pType == null || pType.length < 1) {
            _logger.error((Object)"invalide initail, need generic type parameter! ");
            throw new RuntimeException("invalide initail, need generic type parameter!");
        }
        this.entityClass = (Class)pType[0];
        _logger.trace((Object)("class : " + this.entityClass.getSimpleName()));
    }

    public JpaBaseService(String mapperClass) {
        _logger.trace((Object)("class : " + mapperClass));
        this.mapperClass = mapperClass;
    }

    public IJpaBaseMapper<T> getMapper() {
        try {
            if (this.mapper == null) {
                String mapperClassBean = String.valueOf(this.mapperClass.toLowerCase().charAt(0)) + this.mapperClass.substring(1);
                _logger.info((Object)("mapperClass Bean is " + mapperClassBean));
                this.mapper = (IJpaBaseMapper)WebContext.getBean(mapperClassBean);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"getMapper Exception ", (Throwable)e);
        }
        return this.mapper;
    }

    public void setMapper(IJpaBaseMapper<T> mapper) {
        this.mapper = mapper;
    }

    public JpaPageResults<T> queryPageResults(T entity) {
        ((JpaPagination)entity).setPageResultSelectUUID(((JpaBaseEntity)entity).generateId());
        ((JpaPagination)entity).setStartRow(this.calculateStartRow(((JpaPagination)entity).getPageNumber(), ((JpaPagination)entity).getPageSize()));
        ((JpaPagination)entity).setPageable(true);
        List<T> resultslist = this.getMapper().queryPageResults(entity);
        ((JpaPagination)entity).setPageable(false);
        Integer totalPage = resultslist.size();
        Integer totalCount = 0;
        totalCount = ((JpaPagination)entity).getPageNumber() == 1 && totalPage < ((JpaPagination)entity).getPageSize() ? totalPage : this.parseCount(this.getMapper().queryPageResultsCount(entity));
        return new JpaPageResults<T>(((JpaPagination)entity).getPageNumber(), ((JpaPagination)entity).getPageSize(), (int)totalPage, totalCount, resultslist);
    }

    public JpaPageResults<T> queryPageResults(String mapperId, T entity) {
        ((JpaPagination)entity).setPageResultSelectUUID(((JpaBaseEntity)entity).generateId());
        ((JpaPagination)entity).setStartRow(this.calculateStartRow(((JpaPagination)entity).getPageNumber(), ((JpaPagination)entity).getPageSize()));
        ((JpaPagination)entity).setPageable(true);
        List resultslist = null;
        try {
            resultslist = (List)InstanceUtil.invokeMethod(this.getMapper(), mapperId, new Object[]{entity});
        }
        catch (Exception e) {
            _logger.error((Object)"queryPageResults Exception ", (Throwable)e);
        }
        ((JpaPagination)entity).setPageable(false);
        Integer totalPage = resultslist.size();
        Integer totalCount = 0;
        totalCount = ((JpaPagination)entity).getPageNumber() == 1 && totalPage < ((JpaPagination)entity).getPageSize() ? totalPage : this.parseCount(this.getMapper().queryPageResultsCount(entity));
        return new JpaPageResults(((JpaPagination)entity).getPageNumber(), ((JpaPagination)entity).getPageSize(), (int)totalPage, totalCount, resultslist);
    }

    public Integer queryPageResultsCount(T entity) {
        try {
            if (entity == null) {
                entity = (JpaBaseEntity)this.entityClass.newInstance();
            }
            Integer count = this.getMapper().queryPageResultsCount(entity);
            _logger.debug((Object)("queryCount count : " + count));
            return count;
        }
        catch (Exception e) {
            _logger.error((Object)"queryPageResultsCount Exception ", (Throwable)e);
            return null;
        }
    }

    public List<T> query(T entity) {
        try {
            if (entity == null) {
                entity = (JpaBaseEntity)this.entityClass.newInstance();
                return this.getMapper().query(entity);
            }
            return this.getMapper().query(entity);
        }
        catch (Exception e) {
            _logger.error((Object)"query Exception ", (Throwable)e);
            return null;
        }
    }

    public List<T> findAll() {
        try {
            return this.getMapper().findAll(this.entityClass);
        }
        catch (Exception e) {
            _logger.error((Object)"findAll Exception ", (Throwable)e);
            return null;
        }
    }

    public T load(T entity) {
        try {
            List<T> entityList = this.getMapper().query(entity);
            return (T)(entityList != null && entityList.size() > 0 ? (JpaBaseEntity)entityList.get(0) : null);
        }
        catch (Exception e) {
            _logger.error((Object)"load Exception ", (Throwable)e);
            return null;
        }
    }

    public T get(String id) {
        try {
            _logger.debug((Object)("entityClass  " + this.entityClass.toGenericString() + " , primaryKey " + id));
            return (T)((JpaBaseEntity)this.getMapper().get(this.entityClass, id));
        }
        catch (Exception e) {
            _logger.error((Object)"get Exception ", (Throwable)e);
            return null;
        }
    }

    public T find(Class<T> entityClass, Object primaryKey) {
        try {
            _logger.debug((Object)("entityClass  " + entityClass.toGenericString() + " , primaryKey " + primaryKey));
            return (T)((JpaBaseEntity)this.getMapper().get(entityClass, primaryKey.toString()));
        }
        catch (Exception e) {
            _logger.error((Object)"find Exception ", (Throwable)e);
            return null;
        }
    }

    public boolean insert(T entity) {
        try {
            Integer count = this.getMapper().insert(entity);
            _logger.debug((Object)("insert count : " + count));
            return count > 0;
        }
        catch (Exception e) {
            _logger.error((Object)"insert Exception ", (Throwable)e);
            return false;
        }
    }

    public boolean persist(T entity) {
        return this.insert(entity);
    }

    public boolean merge(T entity) {
        T loadedEntity = this.load(entity);
        if (loadedEntity == null) {
            return this.insert(entity);
        }
        return this.update(entity);
    }

    public boolean update(T entity) {
        try {
            Integer count = this.getMapper().update(entity);
            _logger.debug((Object)("update count : " + count));
            return count > 0;
        }
        catch (Exception e) {
            _logger.error((Object)"update Exception ", (Throwable)e);
            return false;
        }
    }

    public boolean delete(T entity) {
        try {
            Integer count = this.getMapper().delete(entity);
            _logger.debug((Object)("delete count : " + count));
            return count > 0;
        }
        catch (Exception e) {
            _logger.error((Object)"delete Exception ", (Throwable)e);
            return false;
        }
    }

    public boolean remove(String id) {
        try {
            Integer count = this.getMapper().remove(this.entityClass, id);
            _logger.debug((Object)("remove count : " + count));
            return count > 0;
        }
        catch (Exception e) {
            _logger.error((Object)"remove Exception ", (Throwable)e);
            return false;
        }
    }

    public boolean batchInsert(List<T> listEntity) {
        try {
            if (BeanUtil.isNotNull(listEntity)) {
                Integer count = 0;
                for (JpaBaseEntity entity : listEntity) {
                    if (this.getMapper().insert(entity) <= 0) continue;
                    count = count + 1;
                }
                _logger.debug((Object)("batchInsert count : " + count));
                return count > 0;
            }
        }
        catch (Exception e) {
            _logger.error((Object)"batchInsert Exception ", (Throwable)e);
        }
        return false;
    }

    public boolean batchDelete(List<String> idList) {
        try {
            Integer count = this.getMapper().batchDelete(this.entityClass, idList);
            _logger.debug((Object)("batchDelete count : " + count));
            return count > 0;
        }
        catch (Exception e) {
            _logger.error((Object)"batchDelete Exception ", (Throwable)e);
            return false;
        }
    }

    public Integer parseCount(Object totalCount) {
        Integer retTotalCount = 0;
        if (totalCount == null) {
            return retTotalCount;
        }
        retTotalCount = Integer.parseInt(totalCount.toString());
        return retTotalCount;
    }

    public Integer calculateTotalPage(JpaBaseEntity entity, Integer totalCount) {
        return (totalCount + entity.getPageSize() - 1) / entity.getPageSize();
    }

    public Integer calculateStartRow(Integer page, Integer pageSize) {
        return (page - 1) * pageSize;
    }
}

