/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.id;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dromara.mybatis.jpa.id.IdentifierGenerator;
import org.dromara.mybatis.jpa.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialGenerator
implements IdentifierGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SerialGenerator.class);
    private static String OLD_DATETIME = "";
    public static int STATIC_SEQUENCE = 0;
    public static String STATIC_NODE_NUMBER = "--";
    public String ipAddressNodeValue = "";
    private long datacenterId;

    @Override
    public String generate(Object object) {
        return this.next();
    }

    public synchronized String next() {
        String currentDateTime = this.getCurrentSystemDateTime();
        StringBuffer sequenceNumber = new StringBuffer();
        sequenceNumber.append(currentDateTime.substring(0, 8));
        sequenceNumber.append(this.getNodeNumber());
        sequenceNumber.append(currentDateTime.substring(8));
        sequenceNumber.append(this.nextSequence());
        return sequenceNumber.toString();
    }

    public final String getNodeNumber() {
        if (STATIC_NODE_NUMBER.equals("--")) {
            logger.info("ipAddressNodeValue : {}", (Object)this.ipAddressNodeValue);
            if (this.ipAddressNodeValue.indexOf(",") > -1) {
                String[] ipAddressValues;
                String hostIpAddress = MacAddress.getAllHostMacAddress();
                logger.info("hostIpAddress : {}", (Object)hostIpAddress);
                String[] stringArray = ipAddressValues = this.ipAddressNodeValue.split(",");
                int n = ipAddressValues.length;
                int n2 = 0;
                while (n2 < n) {
                    String ipvalue = stringArray[n2];
                    String[] ipNode = ipvalue.split("=");
                    if (ipNode != null && ipNode.length > 0 && hostIpAddress.indexOf(ipNode[0]) > -1) {
                        STATIC_NODE_NUMBER = ipNode[1];
                    }
                    ++n2;
                }
            } else {
                STATIC_NODE_NUMBER = "01";
            }
            logger.info("STATIC_NODE_SEQUENCE_NUMBER : {}", (Object)STATIC_NODE_NUMBER);
            if (STATIC_NODE_NUMBER.length() != 2) {
                logger.error("\u7cfb\u7edf\u8282\u70b9\u53f7\u5fc5\u987b2\u4f4d");
            }
        }
        return STATIC_NODE_NUMBER;
    }

    private final synchronized String nextSequence() {
        STATIC_SEQUENCE = (STATIC_SEQUENCE + 1) % 10000;
        return String.format("%04d", STATIC_SEQUENCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String getCurrentSystemDateTime() {
        String currentdatetime = null;
        String string = OLD_DATETIME;
        synchronized (string) {
            currentdatetime = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            if (!currentdatetime.equals(OLD_DATETIME)) {
                STATIC_SEQUENCE = 0;
                OLD_DATETIME = currentdatetime;
            }
        }
        return currentdatetime;
    }

    public String getIpAddressNodeValue() {
        return this.ipAddressNodeValue;
    }

    public void setIpAddressNodeValue(String ipAddressNodeValue) {
        this.ipAddressNodeValue = ipAddressNodeValue;
        this.getNodeNumber();
    }

    public void setIpAddressNodeValue(InetAddress inetAddress) {
        long id = 0L;
        try {
            NetworkInterface network;
            if (inetAddress == null) {
                inetAddress = InetAddress.getLocalHost();
            }
            if ((network = NetworkInterface.getByInetAddress(inetAddress)) == null) {
                id = 1L;
            } else {
                byte[] mac = network.getHardwareAddress();
                if (mac != null) {
                    id = (0xFFL & (long)mac[mac.length - 2] | 0xFF00L & (long)mac[mac.length - 1] << 8) >> 6;
                    id %= this.datacenterId + 1L;
                }
            }
            this.ipAddressNodeValue = String.valueOf(id);
        }
        catch (Exception e) {
            logger.error(" getDatacenterId Exception", (Throwable)e);
        }
    }
}

