/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.replication;

import com.kingbase8.core.BaseConnection;
import com.kingbase8.replication.KBReplicationConnection;
import com.kingbase8.replication.fluent.ChainedCreateReplicationSlotBuilder;
import com.kingbase8.replication.fluent.ChainedStreamBuilder;
import com.kingbase8.replication.fluent.ReplicationCreateSlotBuilder;
import com.kingbase8.replication.fluent.ReplicationStreamBuilder;
import java.sql.SQLException;
import java.sql.Statement;

public class KBReplicationConnectionImpl
implements KBReplicationConnection {
    private BaseConnection connection;

    public KBReplicationConnectionImpl(BaseConnection connection) {
        this.connection = connection;
    }

    @Override
    public ChainedStreamBuilder replicationStream() {
        return new ReplicationStreamBuilder(this.connection);
    }

    @Override
    public ChainedCreateReplicationSlotBuilder createReplicationSlot() {
        return new ReplicationCreateSlotBuilder(this.connection);
    }

    @Override
    public void dropReplicationSlot(String slotName) throws SQLException {
        if (slotName == null || slotName.isEmpty()) {
            throw new IllegalArgumentException("Replication slot name can't be null or empty");
        }
        try (Statement statement = this.connection.createStatement();){
            statement.execute("DROP_REPLICATION_SLOT " + slotName);
        }
    }
}

