/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.util;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.ModelAndView;

public final class WebContext {
    public static ApplicationContext applicationContext = null;

    public static ApplicationContext getApplicationContext() {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)WebContext.getSession().getServletContext());
    }

    public static Object getBean(String id) {
        if (applicationContext == null) {
            return WebContext.getApplicationContext().getBean(id);
        }
        return applicationContext.getBean(id);
    }

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static String getHttpContextPath() {
        HttpServletRequest httpServletRequest = WebContext.getRequest();
        String domainName = "";
        String httpContextPath = String.valueOf(httpServletRequest.getScheme()) + "://" + domainName;
        int port = httpServletRequest.getServerPort();
        if (!(port == 443 && httpServletRequest.getScheme().equalsIgnoreCase("https") || port == 80 && httpServletRequest.getScheme().equalsIgnoreCase("http"))) {
            httpContextPath = String.valueOf(httpContextPath) + ":" + port;
        }
        httpContextPath = String.valueOf(httpContextPath) + httpServletRequest.getContextPath();
        return httpContextPath;
    }

    public static HttpSession getSession() {
        return WebContext.getRequest().getSession();
    }

    public static HttpSession getSession(boolean create) {
        return WebContext.getRequest().getSession(create);
    }

    public static void setAttribute(String name, Object value) {
        WebContext.getSession().setAttribute(name, value);
    }

    public static Object getAttribute(String name) {
        return WebContext.getSession().getAttribute(name);
    }

    public static void removeAttribute(String name) {
        WebContext.getSession().removeAttribute(name);
    }

    public static String getParameter(String name) {
        return WebContext.getRequest().getParameter(name);
    }

    public static final String getRequestIpAddress() {
        return WebContext.getRequestIpAddress(WebContext.getRequest());
    }

    public static final String getRequestIpAddress(HttpServletRequest request) {
        String ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getRemoteAddr();
        }
        LogFactory.getLog(WebContext.class).debug((Object)("getRequestIpAddress() RequestIpAddress:" + ipAddress));
        return ipAddress;
    }

    public static ModelAndView redirect(String redirectUrl) {
        return new ModelAndView("redirect:" + redirectUrl);
    }

    public static ModelAndView forward(String forwardUrl) {
        return new ModelAndView("forward:" + forwardUrl);
    }
}

