/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.crypto.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.dromara.mybatis.jpa.crypto.utils.BytesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base64Utils {
    private static Logger logger = LoggerFactory.getLogger(Base64Utils.class);

    private Base64Utils() {
    }

    public static String encodeBase64(byte[] simple) {
        String cipher = BytesUtils.bytes2String(Base64.encodeBase64((byte[])simple));
        return cipher;
    }

    public static byte[] decoderBase64(String cipher) {
        byte[] simple = Base64.decodeBase64((String)cipher);
        return simple;
    }

    public static String encode(String simple) {
        return Base64Utils.encodeBase64(simple.getBytes());
    }

    public static String encoder(byte[] simple) {
        return Base64Utils.encodeBase64(simple);
    }

    public static String decode(String cipher) {
        return BytesUtils.bytes2String(Base64Utils.decoderBase64(cipher));
    }

    public static byte[] decoder(String cipher) {
        return Base64Utils.decoderBase64(cipher);
    }

    public static String encodeImage(BufferedImage bufferedImage) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", stream);
            String b64Image = "data:image/png;base64," + java.util.Base64.getEncoder().encodeToString(stream.toByteArray());
            stream.close();
            return b64Image;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String encodeImage(byte[] byteImage) {
        return "data:image/png;base64," + java.util.Base64.getEncoder().encodeToString(byteImage);
    }

    public static String fileToBase64(String fileName) throws IOException {
        String string;
        File file = new File(fileName);
        FileInputStream inputFile = new FileInputStream(file);
        try {
            byte[] buffer = new byte[(int)file.length()];
            inputFile.read(buffer);
            inputFile.close();
            string = Base64Utils.encodeBase64(buffer);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                logger.error("error", (Throwable)e);
                return null;
            }
        }
        inputFile.close();
        return string;
    }

    public static void decodeBase64ToFile(String base64Code, String targetPath) {
        logger.trace("decodeBase64ToFile", (Object)base64Code, (Object)targetPath);
    }

    public static void base64ToFile(String base64Code, String targetPath) throws IOException {
        byte[] buffer = base64Code.getBytes();
        try (FileOutputStream out = new FileOutputStream(targetPath);){
            out.write(buffer);
            out.close();
        }
        catch (FileNotFoundException e) {
            logger.info("error", (Throwable)e);
        }
    }

    public static String base64UrlEncode(byte[] simple) {
        String s = new String(Base64.encodeBase64((byte[])simple));
        s = s.split("=")[0];
        s = s.replace('+', '-');
        s = s.replace('/', '_');
        return s;
    }

    public static byte[] base64UrlDecode(String cipher) {
        Object s = cipher;
        s = ((String)s).replace('-', '+');
        s = ((String)s).replace('_', '/');
        switch (((String)s).length() % 4) {
            case 0: {
                break;
            }
            case 2: {
                s = (String)s + "==";
                break;
            }
            case 3: {
                s = (String)s + "=";
                break;
            }
            default: {
                logger.error("Illegal base64url String!");
            }
        }
        return Base64.decodeBase64((String)s);
    }
}

