/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.interceptor;

import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.dromara.mybatis.jpa.meta.FieldColumnMapper;
import org.dromara.mybatis.jpa.meta.FieldMetadata;
import org.dromara.mybatis.jpa.meta.MapperMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class FieldEncryptInterceptor
implements Interceptor {
    private static Logger logger = LoggerFactory.getLogger(FieldEncryptInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Object entity = invocation.getArgs()[1];
        FieldMetadata.buildColumnList(entity.getClass());
        List<FieldColumnMapper> listFieldColumn = FieldMetadata.getFieldsMap(entity.getClass());
        for (FieldColumnMapper encryptField : listFieldColumn) {
            if (!encryptField.isEncrypted()) continue;
            logger.debug("FieldName {} is need {} Encrypted ", (Object)encryptField.getFieldName(), (Object)encryptField.getEncryptedAnnotation().algorithm());
            encryptField.getField().setAccessible(true);
            String plainValue = (String)encryptField.getField().get(entity);
            String cipherValue = this.decrypt(plainValue, encryptField.getEncryptedAnnotation().algorithm());
            encryptField.getField().set(entity, cipherValue);
        }
        return invocation.proceed();
    }

    private String decrypt(String plainValue, String algorithm) throws SQLException {
        return MapperMetadata.getEncryptFactory().getEncryptor(algorithm.toLowerCase()).encrypt(plainValue);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

