/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.dialect;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.dromara.mybatis.jpa.dialect.Dialect;
import org.dromara.mybatis.jpa.entity.JpaPage;

public class DerbyDialect
extends Dialect {
    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public String getLimitString(String sql, JpaPage page) {
        StringBuilder pagingSelectSql = new StringBuilder(sql.length() + 50);
        pagingSelectSql.append(sql);
        if (page.getStartRow() == 0) {
            pagingSelectSql.append(" fetch first ");
        } else {
            pagingSelectSql.append(" offset ").append(page.getStartRow()).append(" rows fetch next ");
        }
        pagingSelectSql.append(page.getPageSize()).append(" rows only");
        return pagingSelectSql.toString();
    }

    @Override
    public String getPreparedStatementLimitString(String sql, JpaPage pagination) {
        if (pagination.getPageSize() > 0 && pagination.getStartRow() > 0) {
            return sql + " limit ? , ?";
        }
        if (pagination.getPageSize() > 0) {
            return sql + " limit  ? ";
        }
        return sql + " limit ?";
    }

    @Override
    public void setLimitParamters(PreparedStatement preparedStatement, int parameterSize, JpaPage page) {
        try {
            if (page.getPageSize() > 0 && page.getStartRow() > 0) {
                preparedStatement.setInt(++parameterSize, page.getPageSize());
                preparedStatement.setInt(++parameterSize, page.getPageSize());
            } else if (page.getPageSize() > 0) {
                preparedStatement.setInt(++parameterSize, page.getPageSize());
            } else {
                preparedStatement.setInt(++parameterSize, 1000);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return "DerbyDialect [" + String.valueOf(DerbyDialect.class) + "]";
    }
}

