/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.client.utils;

import java.lang.management.ManagementFactory;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import org.maxkey.client.crypto.Base64Utils;

public class StringGenerator {
    private static final int MAX_PID = 65536;
    private char[] DEFAULT_CODEC = "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    public static final char[] DEFAULT_CODE_NUMBER = "1234567890".toCharArray();
    public static final char[] DEFAULT_CODE_LOWERCASE = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    public static final char[] DEFAULT_CODE_UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    public static final char[] DEFAULT_CODE_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    public static final char[] DEFAULT_CODE_NUMBER_LETTERS = "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    public static int processId;
    private static final String uuidRegex = "^[0-9a-z]{8}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{12}$";
    private Random random = new SecureRandom();
    private int length;

    static {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            throw new RuntimeException("Could not get PID");
        }
        try {
            processId = Integer.parseInt(jvmName.substring(0, index)) % 65536;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Could not get PID");
        }
    }

    public StringGenerator() {
        this(6);
    }

    public StringGenerator(int length) {
        this.length = length;
    }

    public StringGenerator(char[] defaultCode, int length) {
        this.DEFAULT_CODEC = defaultCode;
        this.length = length;
    }

    public String randomGenerate() {
        byte[] verifierBytes = new byte[this.length];
        this.random.nextBytes(verifierBytes);
        return this.getString(verifierBytes);
    }

    public String uuidGenerate() {
        return UUID.randomUUID().toString().toLowerCase();
    }

    public String uniqueGenerate() {
        StringBuffer uniqueString = new StringBuffer("");
        this.length = 9;
        String randomString = this.randomGenerate();
        uniqueString.append(randomString.subSequence(0, 4));
        Date currentDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyyHHmmssSSS");
        String dateString = Base64Utils.encodeBase64(dateFormat.format(currentDate).getBytes());
        dateString = dateString.substring(0, dateString.length() - 1);
        uniqueString.append(dateString);
        uniqueString.append(randomString.subSequence(5, 8));
        return uniqueString.toString();
    }

    protected String getString(byte[] verifierBytes) {
        char[] chars = new char[verifierBytes.length];
        int i = 0;
        while (i < verifierBytes.length) {
            chars[i] = this.DEFAULT_CODEC[(verifierBytes[i] & 0xFF) % this.DEFAULT_CODEC.length];
            ++i;
        }
        return new String(chars);
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public static boolean uuidMatches(String uuidString) {
        return uuidString.matches(uuidRegex);
    }
}

