/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.extractors;

import com.connsec.client.oauth.exceptions.OAuthException;
import com.connsec.client.oauth.extractors.AccessTokenExtractor;
import com.connsec.client.oauth.model.Token;
import com.connsec.client.utils.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonTokenExtractor
implements AccessTokenExtractor {
    private Pattern accessTokenPattern = Pattern.compile("\"access_token\":\\s*\"(\\S*?)\"");

    public Token extract(String response) {
        Preconditions.checkEmptyString((String)response, (String)"Cannot extract a token from a null or empty String");
        Matcher matcher = this.accessTokenPattern.matcher(response);
        if (matcher.find()) {
            return new Token(matcher.group(1), "", response);
        }
        throw new OAuthException("Cannot extract an acces token. Response was: " + response);
    }
}

