/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth;

import com.connsec.client.http.AuthorizationHeader;
import com.connsec.client.http.HttpVerb;
import com.connsec.client.http.Response;
import com.connsec.client.oauth.domain.OIDCUserInfo;
import com.connsec.client.oauth.domain.UserInfo;
import com.connsec.client.oauth.model.OAuthRequest;
import com.connsec.client.oauth.model.Token;
import com.connsec.client.utils.JsonUtils;
import com.connsec.client.utils.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OAuthClient {
    private static Log log = LogFactory.getLog(OAuthClient.class);
    public static String OAUTH_V20_USERINFO_URI = "http://login.connsec.com/maxkey/api/oauth/v20/me";
    public static String OAUTH_V10A_USERINFO_URI = "http://login.connsec.com/maxkey/api/oauth/v10a/me";
    public static String OPENID_CONNECT_V10A_USERINFO_URI = "http://login.connsec.com/maxkey/api/connect/v10/userinfo";
    private HttpVerb method = HttpVerb.GET;
    private OAuthRequest request;

    public OAuthClient(String url) {
        Preconditions.checkEmptyString((String)url, (String)"Invalid request url");
        this.request = new OAuthRequest(this.method, url);
    }

    public OAuthClient(String url, String accessToken) {
        Preconditions.checkEmptyString((String)url, (String)"Invalid request url");
        this.request = new OAuthRequest(this.method, url);
        this.addParameter("access_token", accessToken);
    }

    public OAuthClient(String url, HttpVerb method) {
        Preconditions.checkEmptyString((String)url, (String)"Invalid request url");
        if (method != null) {
            this.method = method;
        }
        this.request = new OAuthRequest(method, url);
    }

    public void signAccessToken(Token accessToken) {
        Preconditions.checkNotNull((Object)this.request, (String)"OAuthRequest is null");
        this.addParameter("access_token", accessToken.getToken());
    }

    public void addParameter(String name, String value) {
        Preconditions.checkEmptyString((String)name, (String)"parameter name is null");
        Preconditions.checkNotNull((Object)this.request, (String)"OAuthRequest is null");
        if (HttpVerb.GET == this.method) {
            this.request.addQuerystringParameter(name, value);
        } else if (HttpVerb.POST == this.method) {
            this.request.addBodyParameter(name, value);
        }
    }

    public void addHeader(String name, String value) {
        Preconditions.checkEmptyString((String)name, (String)"parameter name is null");
        Preconditions.checkNotNull((Object)this.request, (String)"OAuthRequest is null");
        this.request.addHeader(name, value);
    }

    public Response execute() {
        return this.request.send();
    }

    public Token requestAccessToken() {
        String tokenString = this.execute().getBody();
        Token token = (Token)JsonUtils.gson2Object((String)tokenString, Token.class);
        log.debug((Object)("Request token : " + token));
        return token;
    }

    public void addBasicAuthorization(String username, String password) {
        Preconditions.checkEmptyString((String)username, (String)"parameter username is null");
        Preconditions.checkEmptyString((String)password, (String)"parameter password is null");
        Preconditions.checkNotNull((Object)this.request, (String)"OAuthRequest is null");
        this.request.addHeader(AuthorizationHeader.AUTHORIZATION_HEADERNAME, AuthorizationHeader.createBasic((String)username, (String)password));
    }

    public void addBearerAuthorization(String bearer) {
        Preconditions.checkEmptyString((String)bearer, (String)"parameter bearer is null");
        Preconditions.checkNotNull((Object)this.request, (String)"OAuthRequest is null");
        this.request.addHeader(AuthorizationHeader.AUTHORIZATION_HEADERNAME, AuthorizationHeader.createBearer((String)bearer));
    }

    public UserInfo getUserInfo(String accessToken) {
        this.addParameter("access_token", accessToken);
        Response response = this.execute();
        log.debug((Object)("Request UserInfo : " + response.getBody()));
        UserInfo userInfo = (UserInfo)JsonUtils.gson2Object((String)response.getBody(), UserInfo.class);
        userInfo.setResponseString(response.getBody());
        if (userInfo.getError() == null || !"".equals(userInfo.getError().trim())) {
            // empty if block
        }
        log.debug((Object)("UserInfo : " + userInfo));
        return userInfo;
    }

    public OIDCUserInfo getOIDCUserInfo(String accessToken) {
        this.addHeader("Authorization", accessToken);
        Response response = this.execute();
        log.debug((Object)("Request OIDCUserInfo : " + response.getBody()));
        OIDCUserInfo userInfo = (OIDCUserInfo)JsonUtils.gson2Object((String)response.getBody(), OIDCUserInfo.class);
        userInfo.setResponseString(response.getBody());
        if (userInfo.getError() == null || !"".equals(userInfo.getError().trim())) {
            // empty if block
        }
        log.debug((Object)("UserInfo : " + userInfo));
        return userInfo;
    }

    public void addRestContent(String content) {
        this.request.addRestContent(content);
    }

    public void addRestObject(Object content) {
        this.request.addRestObject(content);
    }

    public void addRestContent(byte[] content) {
        this.request.addRestContent(content);
    }
}

