/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.apache.tsik.xmlsig.DSAVerifyingKey;
import org.apache.tsik.xmlsig.KeyInfo;
import org.apache.tsik.xmlsig.RSAVerifyingKey;
import org.apache.tsik.xmlsig.VerifyingKey;

public class VerifyingKeyFactory {
    private VerifyingKeyFactory() {
    }

    public static VerifyingKey makeVerifyingKey(KeyInfo keyInfo) throws GeneralSecurityException {
        X509Certificate[] certs = keyInfo.getCertificateChain();
        if (certs != null) {
            return VerifyingKeyFactory.makeVerifyingKey(certs);
        }
        PublicKey key = keyInfo.getKeyValue();
        if (key != null) {
            return VerifyingKeyFactory.makeVerifyingKey(key);
        }
        return null;
    }

    public static VerifyingKey makeVerifyingKey(Key key) throws GeneralSecurityException {
        if (key instanceof RSAPublicKey) {
            return new RSAVerifyingKey((PublicKey)key);
        }
        if (key instanceof DSAPublicKey) {
            return new DSAVerifyingKey((PublicKey)key);
        }
        return null;
    }

    public static VerifyingKey makeVerifyingKey(X509Certificate[] certs) throws GeneralSecurityException {
        PublicKey key = certs[0].getPublicKey();
        if (key instanceof RSAPublicKey) {
            return new RSAVerifyingKey(certs);
        }
        if (key instanceof DSAPublicKey) {
            return new DSAVerifyingKey(certs);
        }
        return null;
    }
}

