/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xml.schema.loader;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.tsik.xml.schema.AttributeDeclaration;
import org.apache.tsik.xml.schema.DOMOperations;
import org.apache.tsik.xml.schema.ElementDeclaration;
import org.apache.tsik.xml.schema.Facet;
import org.apache.tsik.xml.schema.Schema;
import org.apache.tsik.xml.schema.SchemaConstants;
import org.apache.tsik.xml.schema.SchemaErrorListener;
import org.apache.tsik.xml.schema.SchemaException;
import org.apache.tsik.xml.schema.Type;
import org.apache.tsik.xml.schema.loader.AnyTypeImpl;
import org.apache.tsik.xml.schema.loader.AttributeDeclarationImpl;
import org.apache.tsik.xml.schema.loader.AttributeGroupImpl;
import org.apache.tsik.xml.schema.loader.ComplexTypeImpl;
import org.apache.tsik.xml.schema.loader.ElementDeclarationImpl;
import org.apache.tsik.xml.schema.loader.FacetImpl;
import org.apache.tsik.xml.schema.loader.ParticleImpl;
import org.apache.tsik.xml.schema.loader.SchemaComponentBase;
import org.apache.tsik.xml.schema.loader.SchemaComponentImpl;
import org.apache.tsik.xml.schema.loader.SchemaDocumentLoader;
import org.apache.tsik.xml.schema.loader.SimpleTypeImpl;
import org.apache.tsik.xml.schema.loader.TypeImpl;
import org.apache.tsik.xml.schema.loader.ValueType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class SchemaImpl
implements Schema,
SchemaConstants {
    private static final String TYPE = "T";
    private static final String ELEM = "E";
    private static final String GROUP = "G";
    private static final String ATTR = "A";
    private static final String ATTR_GROUP = "AG";
    static DOMOperations ops = DOMOperations.getInstance();
    String NS_XS;
    String NS_XSI;
    private boolean gotFirstSchemaDocument;
    private String defaultNamespaceURI;
    private SchemaDocumentLoader docLoader;
    private LinkedList readQueue;
    private HashMap defMap;
    private HashSet namespaces;
    private AnyTypeImpl anyType;
    private AnyTypeImpl anySimpleType;
    private SchemaErrorListener errorListener;

    SchemaImpl(SchemaDocumentLoader docLoader, SchemaErrorListener errorListener) {
        this.docLoader = docLoader;
        this.errorListener = errorListener;
        this.defaultNamespaceURI = null;
        this.readQueue = new LinkedList();
        this.defMap = new HashMap();
        this.namespaces = new HashSet();
        try {
            Document[] docs = docLoader.loadRequiredDocuments();
            if (docs != null) {
                for (int i = 0; i < docs.length; ++i) {
                    this.buildSymbolTable(docs[i]);
                }
                this.processReadQueue();
            }
        }
        catch (ReportedError e) {
        }
        catch (SchemaException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.callListener(null, e.toString());
        }
    }

    public String getSchemaNamespace() {
        if (this.NS_XS == null) {
            throw new IllegalStateException();
        }
        return this.NS_XS;
    }

    public String getSchemaInstanceNamespace() {
        if (this.NS_XSI == null) {
            throw new IllegalStateException();
        }
        return this.NS_XSI;
    }

    private void callListener(String rule, String message) {
        if (rule == null) {
            rule = "null";
        }
        Object[] values = new Object[]{message};
        SchemaException e = new SchemaException(rule, values);
        this.errorListener.schemaError(e);
    }

    void error(String rule, String message) {
        this.callListener(rule, message);
        throw new ReportedError();
    }

    void error(String rule, String message, Node node, String attr) {
        this.error(rule, message, node, attr, null);
    }

    void error(String rule, String message, Node node) {
        this.error(rule, message, node, null, null);
    }

    void error(String rule, String message, Node node, String attr, String attrNS) {
        if (attr != null && node != null) {
            node = ((Element)node).getAttributeNodeNS(attrNS, attr);
        }
        this.error(rule, "[" + this.getNodePath(node) + "] " + message);
    }

    void error(String rule, Throwable e, Node node, String attr, String attrNS) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(new BufferedOutputStream(baos));
        e.printStackTrace(ps);
        this.error(rule, baos.toString(), node, attr, attrNS);
    }

    private String getNodePath(Node node) {
        if (node == null) {
            return "null";
        }
        String name = node.getNodeName();
        if (node.getNodeType() == 1) {
            node = node.getParentNode();
            return this.getNodePath(node) + '/' + name;
        }
        if (node.getNodeType() == 2) {
            node = ((Attr)node).getOwnerElement();
            return this.getNodePath(node) + "/@" + name;
        }
        if (node.getNodeType() == 9) {
            return "";
        }
        return "unknown";
    }

    static String key(String kind, String namespaceURI, String localName) {
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if (localName == null || localName.length() == 0) {
            throw new IllegalArgumentException();
        }
        return kind + ':' + namespaceURI + ':' + localName;
    }

    public Type getType(String namespaceURI, String localName) {
        return (Type)((Object)this.getDef(TYPE, namespaceURI, localName));
    }

    public ElementDeclaration getElement(String namespaceURI, String localName) {
        return (ElementDeclaration)((Object)this.getDef(ELEM, namespaceURI, localName));
    }

    public AttributeDeclaration getAttribute(String namespaceURI, String localName) {
        return (AttributeDeclaration)((Object)this.getDef(ATTR, namespaceURI, localName));
    }

    public Iterator getAllTypes() {
        return this.getAllDefs(TYPE);
    }

    public Iterator getAllElements() {
        return this.getAllDefs(ELEM);
    }

    public Iterator getAllAttributes() {
        return this.getAllDefs(ATTR);
    }

    private Iterator getAllDefs(String kind) {
        kind = kind + ':';
        ArrayList list = new ArrayList();
        Iterator i = this.defMap.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.startsWith(kind)) continue;
            SchemaComponentBase sc = (SchemaComponentBase)this.defMap.get(key);
            list.add(this.defMap.get(key));
        }
        return list.iterator();
    }

    TypeImpl getType(Element element, String ref) {
        return (TypeImpl)this.getByRef(element, ref, TYPE, "type");
    }

    ElementDeclarationImpl getElement(Element element, String ref) {
        return (ElementDeclarationImpl)this.getByRef(element, ref, ELEM, "element");
    }

    AttributeDeclarationImpl getAttribute(Element element, String ref) {
        return (AttributeDeclarationImpl)this.getByRef(element, ref, ATTR, "attribute");
    }

    ParticleImpl getGroupParticle(Element element, String ref) {
        return (ParticleImpl)this.getByRef(element, ref, GROUP, "group");
    }

    AttributeGroupImpl getAttributeGroup(Element element, String ref) {
        return (AttributeGroupImpl)this.getByRef(element, ref, ATTR_GROUP, "attributeGroup");
    }

    private SchemaComponentBase getByRef(Element element, String ref, String kind, String label) {
        SchemaComponentBase sc;
        String name = ops.getLocalName(ref);
        String prefix = ops.getPrefix(ref);
        String namespaceURI = ops.resolvePrefix(prefix, element);
        if (prefix != null && namespaceURI == null) {
            this.error(null, "namespace prefix not found: " + prefix, element);
        }
        if ((sc = this.getDef(kind, namespaceURI, name)) == null) {
            this.error(null, label + " not found: " + name + ' ' + namespaceURI, element);
        }
        return sc;
    }

    private SchemaComponentBase getDef(String kind, String namespaceURI, String localName) {
        try {
            if (!this.loadNamespace(namespaceURI)) {
                return null;
            }
            String key = SchemaImpl.key(kind, namespaceURI, localName);
            SchemaComponentBase sc = (SchemaComponentBase)this.defMap.get(key);
            if (sc == null) {
                return null;
            }
            return sc;
        }
        catch (ReportedError e) {
            return null;
        }
    }

    private void registerType(TypeImpl type) {
        this.registerDef(TYPE, type);
    }

    private void registerDef(String kind, SchemaComponentImpl sc) {
        this.registerDef(kind, sc.getNamespaceURI(), sc.getLocalName(), sc);
    }

    private void registerDef(String kind, String namespaceURI, String name, SchemaComponentBase sc) {
        this.defMap.put(SchemaImpl.key(kind, namespaceURI, name), sc);
        if (!sc.hasBeenRead) {
            this.readQueue.add(sc);
        }
    }

    AnyTypeImpl getAnyType() {
        return this.anyType;
    }

    AnyTypeImpl getAnySimpleType() {
        return this.anySimpleType;
    }

    private boolean loadNamespace(String namespaceURI) {
        if (namespaceURI == null || namespaceURI.length() == 0) {
            return true;
        }
        if (this.namespaces.contains(namespaceURI)) {
            return true;
        }
        Document[] docs = this.docLoader.loadDocumentsByNamespace(namespaceURI);
        if (docs != null) {
            this.namespaces.add(namespaceURI);
            for (int i = 0; i < docs.length; ++i) {
                this.buildSymbolTable(docs[i]);
            }
            this.processReadQueue();
            return true;
        }
        return false;
    }

    private void doImport(Element e) {
        String ns = e.getAttribute("namespace");
        if (ns.length() == 0) {
            this.error(null, "<import> must have 'namespace' attribute", e);
        }
        if (!this.loadNamespace(ns)) {
            this.error(null, "imported namespace not found: " + ns, e);
        }
    }

    static boolean isSomeSchemaNamespace(String uri) {
        return "http://www.w3.org/2001/XMLSchema".equals(uri) || "http://www.w3.org/2000/10/XMLSchema".equals(uri);
    }

    private void buildSymbolTable(Document schemaDoc) {
        Element schema = schemaDoc.getDocumentElement();
        if (!"schema".equals(ops.getLocalName(schema))) {
            return;
        }
        String targetNamespace = schema.getAttribute("targetNamespace");
        if (targetNamespace.length() == 0) {
            targetNamespace = this.defaultNamespaceURI;
        }
        String schemaNamespace = ops.getNamespaceURI(schema);
        if (this.gotFirstSchemaDocument) {
            if (!this.NS_XS.equals(schemaNamespace)) {
                this.error(null, "may not mix different versions of the schema namespace URI", schema);
                return;
            }
        } else {
            if ("http://www.w3.org/2001/XMLSchema".equals(schemaNamespace)) {
                this.NS_XS = "http://www.w3.org/2001/XMLSchema";
                this.NS_XSI = "http://www.w3.org/2001/XMLSchema-instance";
            } else if ("http://www.w3.org/2000/10/XMLSchema".equals(schemaNamespace)) {
                this.NS_XS = "http://www.w3.org/2000/10/XMLSchema";
                this.NS_XSI = "http://www.w3.org/2000/10/XMLSchema-instance";
            } else {
                this.error(null, "unknown schema namespace: " + schemaNamespace, schema);
                return;
            }
            this.gotFirstSchemaDocument = true;
            this.addBuiltinTypes();
        }
        Element e = ops.firstElementChild(schema);
        while (e != null) {
            if (this.NS_XS.equals(ops.getNamespaceURI(e))) {
                TypeImpl type;
                String tag = ops.getLocalName(e);
                String name = e.getAttribute("name");
                if (tag.equals("import")) {
                    this.doImport(e);
                } else if (tag.equals("include") || tag.equals("redefine")) {
                    this.error(null, "<include> and <redefine> not allowed", e);
                } else if (tag.equals("simpleType")) {
                    type = new SimpleTypeImpl(e, targetNamespace, name, this);
                    this.registerType(type);
                } else if (tag.equals("complexType")) {
                    type = new ComplexTypeImpl(e, targetNamespace, name, this);
                    this.registerType(type);
                } else if (tag.equals("element")) {
                    ElementDeclarationImpl elem = new ElementDeclarationImpl(e, targetNamespace, name, this);
                    this.registerDef(ELEM, elem);
                } else if (tag.equals("attribute")) {
                    AttributeDeclarationImpl attr = new AttributeDeclarationImpl(e, targetNamespace, name, this);
                    this.registerDef(ATTR, attr);
                } else if (tag.equals("group")) {
                    ParticleImpl particle = new ParticleImpl(e, this);
                    this.registerDef(GROUP, targetNamespace, name, particle);
                } else if (tag.equals("attributeGroup")) {
                    AttributeGroupImpl group = new AttributeGroupImpl(ops.firstElementChild(e), this);
                    this.registerDef(ATTR_GROUP, targetNamespace, name, group);
                }
            }
            e = ops.nextElementSibling(e);
        }
    }

    private void processReadQueue() {
        while (!this.readQueue.isEmpty()) {
            SchemaComponentBase sc = (SchemaComponentBase)this.readQueue.remove(0);
            sc.resolve();
        }
    }

    String getSchemaAttribute(Node node, String name) {
        while (node != null) {
            if (node.getNodeType() == 1 && ops.matchName(node, this.NS_XS, "schema")) {
                return ((Element)node).getAttribute(name);
            }
            node = ops.parent(node);
        }
        this.error(null, "schema element not found", node);
        return null;
    }

    static boolean parentIsSchema(Node node) {
        return SchemaImpl.isSomeSchemaNamespace(ops.getNamespaceURI(node = node.getParentNode())) && "schema".equals(ops.getLocalName(node));
    }

    void addBuiltinTypes() {
        this.namespaces.add(this.NS_XS);
        this.anyType = new AnyTypeImpl(this);
        this.registerType(this.anyType);
        this.anySimpleType = new AnyTypeImpl(this.anyType, this);
        this.registerType(this.anySimpleType);
        Facet[] wsPreserve = new Facet[]{new FacetImpl.WhiteSpace(1, false)};
        Facet[] wsReplace = new Facet[]{new FacetImpl.WhiteSpace(2, true)};
        Facet[] wsCollapse = new Facet[]{new FacetImpl.WhiteSpace(3, true)};
        this.registerType(new SimpleTypeImpl(this.NS_XS, "string", this, 2, null, ValueType.STRING, wsPreserve, false, false, 2, false));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "boolean", this, 2, null, ValueType.BOOLEAN, wsCollapse, false, false, 1, false));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "float", this, 2, null, ValueType.FLOAT, wsCollapse, true, true, 1, true));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "double", this, 2, null, ValueType.DOUBLE, wsCollapse, true, true, 1, true));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "decimal", this, 2, null, ValueType.DECIMAL, wsCollapse, true, false, 2, true));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "QName", this, 2, null, ValueType.QNAME, wsCollapse, true, false, 2, false));
        if (this.NS_XS == "http://www.w3.org/2000/10/XMLSchema") {
            this.registerType(new SimpleTypeImpl(this.NS_XS, "timeDuration", this, 2, null, ValueType.TIME_DURATION, wsCollapse, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "recurringDuration", this, 2, null, null, wsCollapse, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "binary", this, 2, null, null, wsCollapse, false, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "uriReference", this, 2, null, ValueType.URI_REFERENCE, wsCollapse, false, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "NOTATION", this, 2, "QName", null, null, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "CDATA", this, 2, "string", null, wsReplace, false, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "token", this, 2, "CDATA", null, wsCollapse, false, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "timeInstant", this, 2, "recurringDuration", ValueType.TIME_INSTANT, null, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "time", this, 2, "recurringDuration", ValueType.TIME, null, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "timePeriod", this, 2, "recurringDuration", null, null, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "date", this, 2, "timePeriod", ValueType.DATE, null, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "month", this, 2, "timePeriod", ValueType.MONTH, null, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "year", this, 2, "timePeriod", ValueType.YEAR, null, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "century", this, 2, "timePeriod", ValueType.CENTURY, null, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "recurringDate", this, 2, "recurringDuration", ValueType.RECURRING_DATE, null, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "recurringDay", this, 2, "recurringDuration", ValueType.RECURRING_DAY, null, true, false, 2, false));
        } else {
            this.registerType(new SimpleTypeImpl(this.NS_XS, "duration", this, 2, null, ValueType.TIME_DURATION, wsCollapse, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "dateTime", this, 2, null, ValueType.TIME_INSTANT, wsCollapse, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "time", this, 2, null, ValueType.TIME, wsCollapse, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "date", this, 2, null, ValueType.DATE, wsCollapse, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "gYearMonth", this, 2, null, ValueType.MONTH, wsCollapse, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "gYear", this, 2, null, ValueType.YEAR, wsCollapse, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "gMonthDay", this, 2, null, ValueType.RECURRING_DATE, wsCollapse, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "gDay", this, 2, null, ValueType.RECURRING_DAY, wsCollapse, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "gMonth", this, 2, null, ValueType.RECURRING_MONTH, wsCollapse, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "hexBinary", this, 2, null, ValueType.BINARY_HEX, wsCollapse, false, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "base64Binary", this, 2, null, ValueType.BINARY_BASE64, wsCollapse, false, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "anyURI", this, 2, null, ValueType.URI_REFERENCE, wsCollapse, false, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "NOTATION", this, 2, null, ValueType.QNAME, wsCollapse, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "normalizedString", this, 2, "string", null, wsReplace, false, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "token", this, 2, "normalizedString", null, wsCollapse, false, false, 2, false));
        }
        this.registerType(new SimpleTypeImpl(this.NS_XS, "Name", this, 2, "token", ValueType.NAME, null, false, false, 2, false));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "NCName", this, 2, "Name", ValueType.NCNAME, null, false, false, 2, false));
        if (this.NS_XS == "http://www.w3.org/2000/10/XMLSchema") {
            this.registerType(new SimpleTypeImpl(this.NS_XS, "ID", this, 2, null, ValueType.NCNAME, wsCollapse, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "IDREF", this, 2, null, ValueType.NCNAME, wsCollapse, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "ENTITY", this, 2, null, ValueType.NCNAME, wsCollapse, true, false, 2, false));
        } else {
            this.registerType(new SimpleTypeImpl(this.NS_XS, "ID", this, 2, "NCName", ValueType.NCNAME, wsCollapse, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "IDREF", this, 2, "NCName", ValueType.NCNAME, wsCollapse, true, false, 2, false));
            this.registerType(new SimpleTypeImpl(this.NS_XS, "ENTITY", this, 2, "NCName", ValueType.NCNAME, wsCollapse, true, false, 2, false));
        }
        this.registerType(new SimpleTypeImpl(this.NS_XS, "language", this, 2, "token", null, null, false, false, 2, false));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "IDREFS", this, 4, "IDREF", null, null, false, false, 2, false));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "ENTITIES", this, 4, "ENTITY", null, null, false, false, 2, false));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "NMTOKEN", this, 2, "token", ValueType.NMTOKEN, null, false, false, 2, false));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "NMTOKENS", this, 4, "NMTOKEN", null, null, false, false, 2, false));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "integer", this, 2, "decimal", ValueType.INTEGER, new Facet[]{new FacetImpl.Scale(new Long(0L), true, ValueType.INTEGER)}, true, false, 2, true));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "nonPositiveInteger", this, 2, "integer", null, new Facet[]{new FacetImpl.MaxInclusive(BigInteger.valueOf(0L), false, ValueType.INTEGER)}, true, false, 2, true));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "negativeInteger", this, 2, "nonPositiveInteger", null, new Facet[]{new FacetImpl.MaxInclusive(BigInteger.valueOf(-1L), false, ValueType.INTEGER)}, true, false, 2, true));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "long", this, 2, "integer", null, new Facet[]{new FacetImpl.MaxInclusive(BigInteger.valueOf(Long.MAX_VALUE), false, ValueType.INTEGER), new FacetImpl.MinInclusive(BigInteger.valueOf(Long.MIN_VALUE), false, ValueType.INTEGER)}, true, true, 1, true));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "int", this, 2, "long", null, new Facet[]{new FacetImpl.MaxInclusive(BigInteger.valueOf(Integer.MAX_VALUE), false, ValueType.INTEGER), new FacetImpl.MinInclusive(BigInteger.valueOf(Integer.MIN_VALUE), false, ValueType.INTEGER)}, true, true, 1, true));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "short", this, 2, "int", null, new Facet[]{new FacetImpl.MaxInclusive(BigInteger.valueOf(32767L), false, ValueType.INTEGER), new FacetImpl.MinInclusive(BigInteger.valueOf(-32768L), false, ValueType.INTEGER)}, true, true, 1, true));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "byte", this, 2, "short", null, new Facet[]{new FacetImpl.MaxInclusive(BigInteger.valueOf(127L), false, ValueType.INTEGER), new FacetImpl.MinInclusive(BigInteger.valueOf(-128L), false, ValueType.INTEGER)}, true, true, 1, true));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "nonNegativeInteger", this, 2, "integer", null, new Facet[]{new FacetImpl.MinInclusive(BigInteger.valueOf(0L), false, ValueType.INTEGER)}, true, false, 2, true));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "unsignedLong", this, 2, "nonNegativeInteger", null, new Facet[]{new FacetImpl.MaxInclusive(new BigInteger("18446744073709551615"), false, ValueType.INTEGER)}, true, true, 1, true));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "unsignedInt", this, 2, "unsignedLong", null, new Facet[]{new FacetImpl.MaxInclusive(BigInteger.valueOf(0xFFFFFFFFL), false, ValueType.INTEGER)}, true, true, 1, true));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "unsignedShort", this, 2, "unsignedInt", null, new Facet[]{new FacetImpl.MaxInclusive(BigInteger.valueOf(65535L), false, ValueType.INTEGER)}, true, true, 1, true));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "unsignedByte", this, 2, "unsignedShort", null, new Facet[]{new FacetImpl.MaxInclusive(BigInteger.valueOf(255L), false, ValueType.INTEGER)}, true, true, 1, true));
        this.registerType(new SimpleTypeImpl(this.NS_XS, "positiveInteger", this, 2, "nonNegativeInteger", null, new Facet[]{new FacetImpl.MinInclusive(BigInteger.valueOf(1L), false, ValueType.INTEGER)}, true, false, 2, true));
    }

    private static class ReportedError
    extends Error {
        private ReportedError() {
        }
    }
}

