/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.wss.elements;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.tsik.common.SchemaMapper;
import org.apache.tsik.datatypes.Base64;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.wss.elements.SecurityToken;

public class UsernameToken
extends SecurityToken {
    private static Class c = class$org$apache$tsik$wss$elements$UsernameToken == null ? (class$org$apache$tsik$wss$elements$UsernameToken = UsernameToken.class$("org.apache.tsik.wss.elements.UsernameToken")) : class$org$apache$tsik$wss$elements$UsernameToken;
    static String elementName = SchemaMapper.getName(c);
    static String prefix = SchemaMapper.getPrefix(c);
    static String uri = SchemaMapper.getUri(c);
    private static String[] ns = new String[]{prefix, uri};
    private String username;
    private String password;
    private String nonce;
    private String created;
    private static SecureRandom random;
    static /* synthetic */ Class class$org$apache$tsik$wss$elements$UsernameToken;

    public UsernameToken(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public UsernameToken(String username, String password, String nonce, String created) {
        this.username = username;
        this.password = password;
        this.nonce = nonce;
        this.created = created;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public static String generateNonce() throws NoSuchAlgorithmException {
        if (random == null) {
            UsernameToken.initRandom();
        }
        byte[] b = new byte[16];
        random.nextBytes(b);
        return Base64.encode(b);
    }

    private static void initRandom() throws NoSuchAlgorithmException {
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            try {
                random = SecureRandom.getInstance("IBMSecureRandom");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new UnsupportedOperationException(ex.toString());
            }
        }
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, elementName);
        DOMWriteCursor c = wc.addUnder(uri, prefix, "Username");
        c.setText(this.username);
        c = wc.addUnder(uri, prefix, "Password");
        c.setAttribute("Type", prefix + ":PasswordText");
        c.setText(this.password);
        if (this.nonce != null) {
            c = wc.addUnder(uri, prefix, "Nonce");
            c.setText(this.nonce);
        }
        if (this.created != null) {
            c = wc.addUnder(uri, prefix, "Created");
            c.setText(this.created);
        }
    }

    public static UsernameToken fromXml(DOMCursor cursor) {
        DOMCursor c = UsernameToken.placeCursor(cursor, elementName, prefix, uri, ns);
        String username = null;
        String password = null;
        String nonce = null;
        String created = null;
        if (c.moveToChild(uri, "Username")) {
            username = c.getText();
            c.moveToParent();
        }
        if (c.moveToChild(uri, "Password")) {
            password = c.getText();
            c.moveToParent();
        }
        if (c.moveToChild(uri, "Nonce")) {
            nonce = c.getText();
            c.moveToParent();
        }
        if (c.moveToChild(uri, "Created")) {
            created = c.getText();
            c.moveToParent();
        }
        return new UsernameToken(username, password, nonce, created);
    }

    public static boolean isUsernameToken(SecurityToken st) {
        return st instanceof UsernameToken;
    }

    public String toString() {
        String s = "[UsernameToken ";
        if (this.username != null) {
            s = s + " username=" + this.username;
        }
        if (this.password != null) {
            s = s + " password=" + this.password;
        }
        if (this.nonce != null) {
            s = s + " nonce=" + this.nonce;
        }
        if (this.created != null) {
            s = s + " created=" + this.created;
        }
        return s + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

