/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.schema;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.tsik.resource.ResourceFactory;
import org.apache.tsik.schema.SchemaLoaderException;
import org.apache.tsik.xml.schema.Schema;
import org.apache.tsik.xml.schema.SchemaErrorListener;
import org.apache.tsik.xml.schema.SchemaException;
import org.apache.tsik.xml.schema.loader.SchemaDocumentLoader;
import org.apache.tsik.xml.schema.loader.SchemaDocumentLoaderFactory;
import org.apache.tsik.xml.schema.loader.SchemaLoader;
import org.apache.tsik.xml.schema.loader.SchemaLoaderFactory;
import org.apache.tsik.xml.schema.validator.Validator;
import org.apache.tsik.xml.schema.validator.ValidatorFactory;
import org.w3c.dom.Document;

public class SchemaValidator {
    private static final String NEWLINE = System.getProperty("line.separator");
    private Validator validator;
    private StringBuffer errors = new StringBuffer();

    public SchemaValidator(Document[] schemata) throws SchemaLoaderException {
        this.load(schemata);
    }

    public SchemaValidator(File[] schemata) throws SchemaLoaderException, IOException {
        this.load(this.parseFiles(schemata));
    }

    private void load(Document[] schemata) throws SchemaLoaderException {
        this.errors = new StringBuffer();
        MyListener listener = new MyListener(this.errors);
        SchemaLoader loader = SchemaLoaderFactory.newLoader(listener);
        SchemaDocumentLoader docLoader = SchemaDocumentLoaderFactory.newDocumentArrayLoader(schemata);
        Schema schema = loader.loadSchema(docLoader);
        if (this.errors.length() > 0) {
            throw new SchemaLoaderException(this.errors.toString());
        }
        this.validator = ValidatorFactory.getValidator(schema, listener);
    }

    public String validate(Document instance) {
        this.errors.setLength(0);
        this.validator.validateDocument(instance);
        return this.errors.length() > 0 ? this.errors.toString() : null;
    }

    public String validate(File instance) throws IOException {
        return this.validate(this.parseFile(instance));
    }

    private Document[] parseFiles(File[] files) throws IOException {
        Document[] docs = new Document[files.length];
        for (int i = 0; i < docs.length; ++i) {
            docs[i] = this.parseFile(files[i]);
        }
        return docs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document parseFile(File file) throws IOException {
        FileReader reader = new FileReader(file);
        try {
            Document document = ResourceFactory.getXMLResource().parseXML(new BufferedReader(reader));
            return document;
        }
        finally {
            reader.close();
        }
    }

    private class MyListener
    implements SchemaErrorListener {
        private StringBuffer errors;

        private MyListener(StringBuffer errors) {
            this.errors = errors;
        }

        public void schemaError(SchemaException ex) {
            if (this.errors.length() > 0) {
                this.errors.append(NEWLINE);
            }
            this.errors.append(ex.getMessage());
        }
    }
}

