/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.client.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.maxkey.client.crypto.BytesUtils;

public final class Base64Utils {
    public static String encodeBase64(byte[] simple) {
        String cipher = BytesUtils.bytes2String(Base64.encodeBase64((byte[])simple));
        return cipher;
    }

    public static byte[] decoderBase64(String cipher) {
        byte[] simple = Base64.decodeBase64((String)cipher);
        return simple;
    }

    public static String encode(String simple) {
        return Base64Utils.encodeBase64(simple.getBytes());
    }

    public static String encoder(byte[] simple) {
        return Base64Utils.encodeBase64(simple);
    }

    public static String decode(String cipher) {
        return BytesUtils.bytes2String(Base64Utils.decoderBase64(cipher));
    }

    public static byte[] decoder(String cipher) {
        return Base64Utils.decoderBase64(cipher);
    }

    public static String fileToBase64(String fileName) throws Exception {
        File file = new File(fileName);
        FileInputStream inputFile = new FileInputStream(file);
        byte[] buffer = new byte[(int)file.length()];
        inputFile.read(buffer);
        inputFile.close();
        return Base64Utils.encodeBase64(buffer);
    }

    public static void decodeBase64ToFile(String base64Code, String targetPath) throws Exception {
        byte[] buffer = Base64Utils.decoderBase64(base64Code);
        FileOutputStream out = new FileOutputStream(targetPath);
        out.write(buffer);
        out.close();
    }

    public static void base64ToFile(String base64Code, String targetPath) throws Exception {
        byte[] buffer = base64Code.getBytes();
        FileOutputStream out = new FileOutputStream(targetPath);
        out.write(buffer);
        out.close();
    }

    public static String base64UrlEncode(byte[] simple) {
        String s = new String(Base64.encodeBase64((byte[])simple));
        s = s.split("=")[0];
        s = s.replace('+', '-');
        s = s.replace('/', '_');
        return s;
    }

    public static byte[] base64UrlDecode(String cipher) {
        String s = cipher;
        s = s.replace('-', '+');
        s = s.replace('_', '/');
        switch (s.length() % 4) {
            case 0: {
                break;
            }
            case 2: {
                s = s + "==";
                break;
            }
            case 3: {
                s = s + "=";
                break;
            }
            default: {
                System.err.println("Illegal base64url String!");
            }
        }
        return Base64.decodeBase64((String)s);
    }
}

