/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import com.sun.net.ssl.X509TrustManager;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.ssl.Certificates;
import org.apache.commons.ssl.SSL;
import org.apache.commons.ssl.TrustChain;
import org.apache.commons.ssl.TrustMaterial;

public class Java13TrustManagerWrapper
implements X509TrustManager {
    private final X509TrustManager trustManager;
    private final TrustChain trustChain;
    private final SSL ssl;

    public Java13TrustManagerWrapper(X509TrustManager m, TrustChain tc, SSL h) {
        this.trustManager = m;
        this.trustChain = tc;
        this.ssl = h;
    }

    public boolean isClientTrusted(X509Certificate[] chain) {
        this.ssl.setCurrentClientChain(chain);
        boolean firstTest = this.trustManager.isClientTrusted(chain);
        return this.test(firstTest, chain);
    }

    public boolean isServerTrusted(X509Certificate[] chain) {
        this.ssl.setCurrentServerChain(chain);
        boolean firstTest = this.trustManager.isServerTrusted(chain);
        return this.test(firstTest, chain);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    private boolean test(boolean firstTest, X509Certificate[] chain) {
        if (!firstTest && !this.trustChain.contains(TrustMaterial.TRUST_ALL)) {
            return false;
        }
        try {
            for (int i = 0; i < chain.length; ++i) {
                X509Certificate c = chain[i];
                if (this.ssl.getCheckExpiry()) {
                    c.checkValidity();
                }
                if (!this.ssl.getCheckCRL()) continue;
                Certificates.checkCRL(c);
            }
            return true;
        }
        catch (CertificateException ce) {
            return false;
        }
    }
}

