/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.metadata.FieldColumnMapper;
import org.dromara.mybatis.jpa.metadata.MapperMetadata;
import org.dromara.mybatis.jpa.query.Query;
import org.dromara.mybatis.jpa.query.QueryBuilder;
import org.dromara.mybatis.jpa.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchProvider<T extends JpaEntity> {
    private static final Logger logger = LoggerFactory.getLogger(FetchProvider.class);

    public String fetch(Map<String, Object> parametersMap) {
        JpaEntity entity = (JpaEntity)parametersMap.get("entity");
        MapperMetadata.buildColumnList(entity.getClass());
        List listFields = (List)MapperMetadata.fieldsMap.get(entity.getClass().getSimpleName());
        String[] column = new String[listFields.size()];
        int i = 0;
        while (i < listFields.size()) {
            column[i] = ((FieldColumnMapper)listFields.get(i)).getColumnName();
            ++i;
        }
        SQL sql = (SQL)((SQL)new SQL().SELECT(column)).FROM(MapperMetadata.getTableName(entity.getClass()));
        StringBuffer conditions = new StringBuffer();
        for (FieldColumnMapper fieldColumnMapper : listFields) {
            logger.trace("Field {} , Type {} , Value {}", new Object[]{fieldColumnMapper.getFieldName(), fieldColumnMapper.getFieldType(), BeanUtil.get(entity, fieldColumnMapper.getFieldName())});
            if ((fieldColumnMapper.getFieldType().equalsIgnoreCase("String") || fieldColumnMapper.getFieldType().startsWith("byte") || fieldColumnMapper.getFieldType().startsWith("int") || BeanUtil.get(entity, fieldColumnMapper.getFieldName()) == null) && BeanUtil.getValue(entity, fieldColumnMapper.getFieldName()) == null) {
                logger.trace("skip {}({}) is null ", (Object)fieldColumnMapper.getFieldName(), (Object)fieldColumnMapper.getColumnName());
                continue;
            }
            if (!conditions.isEmpty()) {
                conditions.append(" and ");
            }
            if (fieldColumnMapper.isLogicDelete()) {
                conditions.append(" %s = %s ".formatted(fieldColumnMapper.getColumnName(), fieldColumnMapper.getColumnLogic().value()));
                continue;
            }
            conditions.append(" %s = #{%s.%s} ".formatted(fieldColumnMapper.getColumnName(), "entity", fieldColumnMapper.getFieldName()));
        }
        sql.WHERE(conditions.toString());
        logger.trace("Query Page SQL : \n{}", (Object)sql);
        return sql.toString();
    }

    public String fetchByCondition(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get("entityClass");
        Query condition = (Query)parametersMap.get("condition");
        MapperMetadata.buildColumnList(entityClass);
        List listFields = (List)MapperMetadata.fieldsMap.get(entityClass.getSimpleName());
        String[] column = new String[listFields.size()];
        int i = 0;
        while (i < listFields.size()) {
            column[i] = ((FieldColumnMapper)listFields.get(i)).getColumnName();
            ++i;
        }
        SQL sql = (SQL)((SQL)((SQL)new SQL().SELECT(column)).FROM(MapperMetadata.getTableName(entityClass))).WHERE("( " + QueryBuilder.build(condition) + " ) ");
        FieldColumnMapper logicColumnMapper = MapperMetadata.getLogicColumn(entityClass.getSimpleName());
        if (logicColumnMapper != null && logicColumnMapper.isLogicDelete()) {
            sql.WHERE(" ( %s = %s )".formatted(logicColumnMapper.getColumnName(), logicColumnMapper.getColumnLogic().value()));
        }
        logger.trace("query Page By Condition SQL : \n{}", (Object)sql);
        return sql.toString();
    }
}

