/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.interceptor;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Properties;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.statement.PreparedStatementHandler;
import org.apache.ibatis.executor.statement.SimpleStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.dromara.mybatis.jpa.entity.JpaPage;
import org.dromara.mybatis.jpa.entity.JpaPageResultsSqlCache;
import org.dromara.mybatis.jpa.interceptor.AbstractStatementHandlerInterceptor;
import org.dromara.mybatis.jpa.provider.FetchCountProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class StatementHandlerInterceptor
extends AbstractStatementHandlerInterceptor
implements Interceptor {
    private static Logger logger = LoggerFactory.getLogger(StatementHandlerInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Method m = invocation.getMethod();
        if ("prepare".equals(m.getName())) {
            return this.prepare(invocation);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    /*
     * WARNING - void declaration
     */
    private Object prepare(Invocation invocation) throws Throwable {
        StatementHandler statement = this.getStatementHandler(invocation);
        if (statement instanceof SimpleStatementHandler || statement instanceof PreparedStatementHandler) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)statement);
            Object parameterObject = metaObject.getValue("parameterHandler.parameterObject");
            BoundSql boundSql = statement.getBoundSql();
            String sql = boundSql.getSql();
            logger.trace("parameter class {} object  ==> {}", (Object)parameterObject.getClass().getCanonicalName(), parameterObject);
            if (sql.toLowerCase().trim().startsWith("select")) {
                JpaPage page = null;
                Object object = parameterObject;
                if (object instanceof JpaPage) {
                    void parameterObjectPage;
                    JpaPage jpaPage = (JpaPage)object;
                    JpaPage cfr_ignored_0 = (JpaPage)object;
                    page = parameterObjectPage;
                } else if (parameterObject instanceof MapperMethod.ParamMap && ((MapperMethod.ParamMap)parameterObject).containsKey((Object)"page")) {
                    page = (JpaPage)((MapperMethod.ParamMap)parameterObject).get((Object)"page");
                } else {
                    try {
                        for (Object key : ((MapperMethod.ParamMap)parameterObject).entrySet()) {
                            if (!(((MapperMethod.ParamMap)parameterObject).get(key) instanceof JpaPage)) continue;
                            page = (JpaPage)((MapperMethod.ParamMap)parameterObject).get(key);
                            break;
                        }
                    }
                    catch (Exception key) {
                        // empty catch block
                    }
                }
                if (page != null && page.isPageable()) {
                    String boundSqlRemoveBreakingWhitespace = this.removeBreakingWhitespace(sql);
                    logger.trace("prepare  boundSql  ==> {}", (Object)boundSqlRemoveBreakingWhitespace);
                    if (statement instanceof SimpleStatementHandler) {
                        sql = this.dialect.getLimitString(sql, page);
                    } else if (statement instanceof PreparedStatementHandler) {
                        FetchCountProvider.pageResultsBoundSqlCache.put((Object)page.getPageResultSelectUUID(), (Object)new JpaPageResultsSqlCache(sql, boundSql));
                        sql = this.dialect.getLimitString(sql, page);
                    }
                    logger.trace("prepare dialect boundSql : {}", (Object)boundSqlRemoveBreakingWhitespace);
                    metaObject.setValue("boundSql.sql", (Object)sql);
                }
            }
        }
        return invocation.proceed();
    }
}

