/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.util;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.SystemUtils;
import org.joda.time.DateTime;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.support.WebApplicationContextUtils;

public final class JpaWebContext {
    public static String VERSION = null;
    public static StandardEnvironment properties;
    public static ApplicationContext applicationContext;

    static {
        applicationContext = null;
    }

    public static ApplicationContext getApplicationContext() {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)JpaWebContext.getSession().getServletContext());
    }

    public static Object getBean(String id) {
        if (applicationContext == null) {
            return JpaWebContext.getApplicationContext().getBean(id);
        }
        return applicationContext.getBean(id);
    }

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static HttpSession getSession() {
        return JpaWebContext.getRequest().getSession();
    }

    public static HttpSession getSession(boolean create) {
        return JpaWebContext.getRequest().getSession(create);
    }

    public static void setAttribute(String name, Object value) {
        JpaWebContext.getSession().setAttribute(name, value);
    }

    public static Object getAttribute(String name) {
        return JpaWebContext.getSession().getAttribute(name);
    }

    public static void removeAttribute(String name) {
        JpaWebContext.getSession().removeAttribute(name);
    }

    public static String getParameter(String name) {
        return JpaWebContext.getRequest().getParameter(name);
    }

    public static String version() {
        if (VERSION == null) {
            StringBuffer version = new StringBuffer("---------------------------------------------------------------------------------\n");
            version.append("+                                MaxKey \n");
            version.append("+                      Single   Sign   On ( SSO ) \n");
            version.append("+                           Version ");
            version.append(String.valueOf(properties.getProperty("application.formatted-version")) + "\n");
            version.append("+\n");
            version.append(String.format("+                 %sCopyright 2018 - %s https://www.maxkey.top/\n", Character.valueOf('\u00a9'), new DateTime().getYear()));
            version.append("+                 Licensed under the Apache License, Version 2.0 \n");
            version.append("---------------------------------------------------------------------------------\n");
            version.append("+                                JAVA    \n");
            version.append(String.format("+                 %s java version %s, class %s\n", SystemUtils.JAVA_VENDOR, SystemUtils.JAVA_VERSION, SystemUtils.JAVA_CLASS_VERSION));
            version.append(String.format("+                 %s (build %s, %s)\n", SystemUtils.JAVA_VM_NAME, SystemUtils.JAVA_VM_VERSION, SystemUtils.JAVA_VM_INFO));
            version.append("---------------------------------------------------------------------------------\n");
            VERSION = version.toString();
        }
        return VERSION;
    }
}

