/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.repository.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.dromara.mybatis.jpa.IJpaMapper;
import org.dromara.mybatis.jpa.IJpaRepository;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.entity.JpaPage;
import org.dromara.mybatis.jpa.entity.JpaPageResults;
import org.dromara.mybatis.jpa.query.LambdaQuery;
import org.dromara.mybatis.jpa.query.Query;
import org.dromara.mybatis.jpa.util.InstanceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class JpaRepositoryImpl<M extends IJpaMapper<T>, T extends JpaEntity>
implements IJpaRepository<T> {
    private static final Logger logger = LoggerFactory.getLogger(JpaRepositoryImpl.class);
    @JsonIgnore
    private Class entityClass;
    @Autowired
    private M mapper;

    public M getMapper() {
        return this.mapper;
    }

    public JpaRepositoryImpl() {
        Class mapperClass = null;
        Type[] pType = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        if (pType != null && pType.length >= 2) {
            mapperClass = (Class)pType[0];
            this.entityClass = (Class)pType[1];
            logger.trace("Mapper {} , Entity {}", (Object)String.format("%-30s", mapperClass.getSimpleName()), (Object)this.entityClass.getSimpleName());
        } else {
            logger.error("invalide initail, need generic type parameter! ");
        }
    }

    @Override
    public JpaPageResults<T> fetch(JpaPage page, T entity) {
        try {
            this.beforePageResults(page);
            List<T> resultslist = this.getMapper().fetch(page, entity);
            return this.buildPageResults(page, resultslist);
        }
        catch (Exception e) {
            logger.error("fetch Exception ", (Throwable)e);
            return null;
        }
    }

    @Override
    public JpaPageResults<T> fetch(JpaPage page, Query query) {
        try {
            this.beforePageResults(page);
            List resultslist = this.getMapper().fetchByQuery(page, query, this.entityClass);
            return this.buildPageResults(page, resultslist);
        }
        catch (Exception e) {
            logger.error("fetch by Query Exception ", (Throwable)e);
            return null;
        }
    }

    @Override
    public JpaPageResults<T> fetch(JpaPage page, LambdaQuery<T> lambdaQuery) {
        try {
            this.beforePageResults(page);
            List<T> resultslist = this.getMapper().fetchByLambdaQuery(page, lambdaQuery, this.entityClass);
            return this.buildPageResults(page, resultslist);
        }
        catch (Exception e) {
            logger.error("fetch by LambdaQuery Exception ", (Throwable)e);
            return null;
        }
    }

    @Override
    public JpaPageResults<T> fetchPageResults(T entity) {
        try {
            this.beforePageResults((JpaPage)entity);
            List<T> resultslist = this.getMapper().fetchPageResults(entity);
            return this.buildPageResults((JpaPage)entity, resultslist);
        }
        catch (Exception e) {
            logger.error("fetchPageResults Exception ", (Throwable)e);
            return null;
        }
    }

    @Override
    public JpaPageResults<T> fetchPageResults(JpaPage page, T entity) {
        try {
            this.beforePageResults((JpaPage)entity);
            List<T> resultslist = this.getMapper().fetchPageResults(page, entity);
            return this.buildPageResults((JpaPage)entity, resultslist);
        }
        catch (Exception e) {
            logger.error("fetchPageResults page Exception ", (Throwable)e);
            return null;
        }
    }

    @Override
    public JpaPageResults<T> fetchPageResults(String mapperId, T entity) {
        return this.fetchPageResults(mapperId, (JpaPage)null, entity);
    }

    @Override
    public JpaPageResults<T> fetchPageResults(String mapperId, JpaPage page, T entity) {
        try {
            Object[] objectArray;
            this.beforePageResults((JpaPage)entity);
            M m = this.getMapper();
            if (page == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = entity;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = page;
                objectArray = objectArray3;
                objectArray3[1] = entity;
            }
            List resultslist = (List)InstanceUtil.invokeMethod(m, mapperId, objectArray);
            return this.buildPageResults((JpaPage)entity, resultslist);
        }
        catch (NoSuchMethodException e) {
            logger.error("Mapper no fetchPageResults Method Exception ", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("fetchPageResults Exception ", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<T> find(String filter, Object[] args, int[] argTypes) {
        try {
            return this.getMapper().find(this.entityClass, filter, args, argTypes);
        }
        catch (Exception e) {
            logger.error("findAll Exception ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<T> find(String filter) {
        return this.find(filter, null, null);
    }

    @Override
    public T findOne(String filter, Object[] args, int[] argTypes) {
        try {
            List<T> findList = this.find(filter, args, argTypes);
            return (T)(CollectionUtils.isEmpty(findList) ? null : (JpaEntity)findList.get(0));
        }
        catch (Exception e) {
            logger.error("findOne filter Exception ", (Throwable)e);
            return null;
        }
    }

    @Override
    public T findOne(String filter) {
        return (T)this.findOne(filter, null, null);
    }

    @Override
    public List<T> findByIds(List<String> idList) {
        try {
            logger.trace("findByIds {}", idList);
            List findList = this.getMapper().findByIds(this.entityClass, idList, null);
            logger.trace("findByIds count : {}", (Object)findList.size());
            return findList;
        }
        catch (Exception e) {
            logger.error("findByIds Exception ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<T> findByIds(List<String> idList, String partitionKey) {
        try {
            logger.trace("findByIds {} , partitionKey {}", idList, (Object)partitionKey);
            List findList = this.getMapper().findByIds(this.entityClass, idList, partitionKey);
            logger.debug("findByIds count : {}", (Object)findList.size());
            return findList;
        }
        catch (Exception e) {
            logger.error("findByIds Exception ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<T> findAll() {
        try {
            return this.getMapper().findAll(this.entityClass);
        }
        catch (Exception e) {
            logger.error("findAll Exception", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public T get(String id) {
        try {
            logger.debug("entityClass  {} , primaryKey {}", (Object)this.entityClass, (Object)id);
            return (T)((JpaEntity)this.getMapper().get(this.entityClass, id, null));
        }
        catch (Exception e) {
            logger.error("get Exception ", (Throwable)e);
            return null;
        }
    }

    @Override
    public T get(String id, String partitionKey) {
        try {
            logger.debug("entityClass  {} , primaryKey {} , partitionKey {}", new Object[]{this.entityClass, id, partitionKey});
            return (T)((JpaEntity)this.getMapper().get(this.entityClass, id, partitionKey));
        }
        catch (Exception e) {
            logger.error("get Exception ", (Throwable)e);
            return null;
        }
    }

    @Override
    public T get(T entity) {
        try {
            List<T> queryList = this.query(entity);
            return (T)(CollectionUtils.isEmpty(queryList) ? null : (JpaEntity)queryList.get(0));
        }
        catch (Exception e) {
            logger.error("get by entity Exception ", (Throwable)e);
            return null;
        }
    }

    @Override
    public T get(Query query) {
        try {
            List<T> queryList = this.query(query);
            return (T)(CollectionUtils.isEmpty(queryList) ? null : (JpaEntity)queryList.get(0));
        }
        catch (Exception e) {
            logger.error("get by Query Exception ", (Throwable)e);
            return null;
        }
    }

    @Override
    public T get(LambdaQuery<T> lambdaQuery) {
        try {
            List<T> queryList = this.query(lambdaQuery);
            return (T)(CollectionUtils.isEmpty(queryList) ? null : (JpaEntity)queryList.get(0));
        }
        catch (Exception e) {
            logger.error("get by LambdaQuery Exception ", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<T> query(T entity) {
        try {
            if (entity == null) {
                entity = (JpaEntity)this.entityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return this.getMapper().query(entity);
        }
        catch (Exception e) {
            logger.error("query by entity Exception ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<T> query(Query query) {
        try {
            return this.getMapper().queryByQuery(this.entityClass, query);
        }
        catch (Exception e) {
            logger.error("query by Query Exception ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<T> query(LambdaQuery<T> lambdaQuery) {
        try {
            return this.getMapper().queryByLambdaQuery(this.entityClass, lambdaQuery);
        }
        catch (Exception e) {
            logger.error("query by LambdaQuery Exception ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public boolean insert(T entity) {
        try {
            Integer count = this.getMapper().insert(entity);
            logger.debug("insert count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("insert Exception ", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean insertBatch(List<T> listEntity) {
        try {
            if (CollectionUtils.isNotEmpty(listEntity)) {
                Integer count = 0;
                for (JpaEntity entity : listEntity) {
                    if (this.getMapper().insert((JpaEntity)entity) <= 0) continue;
                    Integer n = count;
                    count = count + 1;
                }
                logger.debug("Insert Batch count : {}", (Object)count);
                return count > 0;
            }
        }
        catch (Exception e) {
            logger.error("Insert Batch Exception ", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean persist(T entity) {
        return this.insert(entity);
    }

    @Override
    public boolean merge(T entity) {
        List<T> resultList = this.query(entity);
        if (CollectionUtils.isEmpty(resultList)) {
            return this.insert(entity);
        }
        return this.update(entity);
    }

    @Override
    public boolean update(T entity) {
        try {
            Integer count = this.getMapper().update(entity);
            logger.debug("update count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("update Exception ", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean update(String setSql, Query query) {
        try {
            Integer count = this.getMapper().updateByQuery(this.entityClass, setSql, query);
            logger.debug("update by Query count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("update by Query Exception ", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean update(String setSql, LambdaQuery<T> lambdaQuery) {
        try {
            Integer count = this.getMapper().updateByLambdaQuery(this.entityClass, setSql, lambdaQuery);
            logger.debug("update by LambdaQuery count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("update by LambdaQuery Exception ", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean delete(Query query) {
        try {
            Integer count = this.getMapper().deleteByQuery(this.entityClass, query);
            logger.debug("delete by query count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("delete by query Exception ", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean delete(LambdaQuery<T> lambdaQuery) {
        try {
            Integer count = this.getMapper().deleteByLambdaQuery(this.entityClass, lambdaQuery);
            logger.debug("delete by LambdaQuery count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("delete by LambdaQuery Exception ", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean deleteBatch(List<String> idList) {
        try {
            logger.trace("deleteBatch {}", idList);
            Integer count = this.getMapper().deleteBatch(this.entityClass, idList, null);
            logger.debug("deleteBatch count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("deleteBatch Exception ", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean deleteBatch(List<String> idList, String partitionKey) {
        try {
            logger.trace("deleteBatch {} , partitionKey {}", idList, (Object)partitionKey);
            Integer count = this.getMapper().deleteBatch(this.entityClass, idList, partitionKey);
            logger.debug("deleteBatch count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("deleteBatch Exception ", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean delete(String id) {
        try {
            logger.debug("id {} ", (Object)id);
            Integer count = this.getMapper().deleteById(this.entityClass, id, null);
            logger.debug("delete by id count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("delete by id Exception ", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean delete(String id, String partitionKey) {
        try {
            logger.debug("id {} , partitionKey {}", (Object)id, (Object)partitionKey);
            Integer count = this.getMapper().deleteById(this.entityClass, id, partitionKey);
            logger.debug("delete by id and partitionKey count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("delete by id and partitionKey Exception ", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean softDelete(List<String> idList) {
        try {
            logger.trace("softDelete idList {}", idList);
            Integer count = this.getMapper().softDelete(this.entityClass, idList, null);
            logger.debug("softDelete count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("softDelete by idList Exception ", (Throwable)e);
            return true;
        }
    }

    @Override
    public boolean softDelete(List<String> idList, String partitionKey) {
        try {
            logger.trace("softDelete idList {} , partitionKey {}", idList, (Object)partitionKey);
            Integer count = this.getMapper().softDelete(this.entityClass, idList, partitionKey);
            logger.debug("softDelete idList and partitionKey count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("softDelete idList and partitionKey Exception ", (Throwable)e);
            return true;
        }
    }

    @Override
    public boolean softDelete(String id) {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(id);
        return this.softDelete(idList);
    }

    @Override
    public boolean softDelete(Query query) {
        try {
            Integer count = this.getMapper().softDeleteByQuery(this.entityClass, query);
            logger.debug("softDelete by Query count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("softDelete by Query Exception ", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean softDelete(LambdaQuery<T> lambdaQuery) {
        try {
            Integer count = this.getMapper().softDeleteByLambdaQuery(this.entityClass, lambdaQuery);
            logger.debug("softDelete by LambdaQuery count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            logger.error("softDelete by LambdaQuery Exception ", (Throwable)e);
            return false;
        }
    }

    protected Integer fetchCount(JpaPage page) {
        Integer count = 0;
        try {
            count = this.getMapper().fetchCount(page);
            logger.debug("fetchCount count : {}", (Object)count);
        }
        catch (Exception e) {
            logger.error("fetchCount Exception ", (Throwable)e);
        }
        return count;
    }

    protected Integer parseCount(Object totalCount) {
        Integer retTotalCount = 0;
        if (totalCount == null) {
            return retTotalCount;
        }
        retTotalCount = Integer.parseInt(totalCount.toString());
        return retTotalCount;
    }

    protected Integer calculateTotalPage(JpaEntity entity, Integer totalCount) {
        return (totalCount + entity.getPageSize() - 1) / entity.getPageSize();
    }

    protected Integer calculateStartRow(Integer page, Integer pageSize) {
        return (page - 1) * pageSize;
    }

    protected void beforePageResults(JpaPage page) {
        page.setPageSelectId(page.generateId());
        page.setStartRow(this.calculateStartRow(page.getPageNumber(), page.getPageSize()));
        page.setPageable(true);
    }

    protected JpaPageResults<T> buildPageResults(JpaPage page, List<T> resultslist) {
        Integer records = this.parseRecords(resultslist);
        Integer totalCount = this.fetchCount(page, resultslist);
        return new JpaPageResults<T>(page.getPageNumber(), page.getPageSize(), (int)records, totalCount, resultslist);
    }

    protected Integer parseRecords(List<?> resultslist) {
        return CollectionUtils.isEmpty(resultslist) ? 0 : resultslist.size();
    }

    protected Integer fetchCount(JpaPage page, List<?> resultslist) {
        Integer totalCount = 0;
        page.setPageable(false);
        Integer records = this.parseRecords(resultslist);
        totalCount = page.getPageNumber() == 1 && records < page.getPageSize() ? records : this.parseCount(this.getMapper().fetchCount(page));
        return totalCount;
    }
}

