/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.jdbc;

import com.highgo.jdbc.jdbc.HGBlob;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class HGBlobOutputStream
extends OutputStream {
    private HGBlob parentBlob;
    private long currentPos;

    public HGBlobOutputStream(HGBlob currentBlob, long position) {
        this.parentBlob = currentBlob;
        this.currentPos = position;
    }

    @Override
    public void write(byte[] srcByteArray) throws IOException {
        this.write(srcByteArray, 0, srcByteArray.length);
    }

    @Override
    public void write(byte[] srcByteArray, int offset, int length) throws IOException {
        try {
            if (srcByteArray == null) {
                return;
            }
            int i = this.parentBlob.setBytes(this.currentPos, srcByteArray, offset, length);
            this.currentPos += (long)i;
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
    }

    @Override
    public void write(int b) throws IOException {
        byte[] srcByteArray = new byte[]{(byte)(b & 0xFF)};
        this.write(srcByteArray);
    }
}

