/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mybatis.jpa.datasource.DynamicDataSourceContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.stereotype.Component;

@Component
public class DynamicRoutingDataSource
extends AbstractRoutingDataSource {
    private static final Logger dsLogger = LoggerFactory.getLogger(DynamicRoutingDataSource.class);
    private static final String DEFAULT_DATASOURCE_KEY = "default";
    private static final Map<Object, Object> DATA_SOURCE_MAP = new ConcurrentHashMap<Object, Object>();
    private static String defaultDataSourceKey = "default";

    protected Object determineCurrentLookupKey() {
        String currentKey = DynamicDataSourceContextHolder.getDataSource();
        if (StringUtils.isBlank((CharSequence)currentKey)) {
            currentKey = defaultDataSourceKey;
        }
        dsLogger.debug("Determined current lookup key: {}", (Object)currentKey);
        return currentKey;
    }

    public void setTargetDataSources(Map<Object, Object> targetDataSources) {
        if (ObjectUtils.isNotEmpty(targetDataSources)) {
            super.setTargetDataSources(targetDataSources);
            DATA_SOURCE_MAP.clear();
            DATA_SOURCE_MAP.putAll(targetDataSources);
            super.afterPropertiesSet();
            dsLogger.info("Updated target data sources, total count: {}", (Object)targetDataSources.size());
        } else {
            dsLogger.warn("Target data sources is null or empty");
        }
    }

    public boolean addDataSource(String key, DataSource dataSource) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new IllegalArgumentException("DataSource key cannot be null or empty");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource cannot be null");
        }
        if (DATA_SOURCE_MAP.containsKey(key)) {
            dsLogger.warn("DataSource with key '{}' already exists, skipping registration.", (Object)key);
            return false;
        }
        try (Connection conn = dataSource.getConnection();){
            if (conn == null || conn.isClosed()) {
                throw new SQLException("Failed to obtain a valid connection for key: " + key);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Invalid DataSource for key: " + key, e);
        }
        DATA_SOURCE_MAP.put(key, dataSource);
        super.setTargetDataSources(new ConcurrentHashMap<Object, Object>(DATA_SOURCE_MAP));
        super.afterPropertiesSet();
        dsLogger.info("Successfully added DataSource with key: {}", (Object)key);
        return true;
    }

    public boolean removeDataSource(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return false;
        }
        if (key.equals(defaultDataSourceKey)) {
            dsLogger.warn("Cannot remove default DataSource: {}", (Object)key);
            return false;
        }
        Object removed = DATA_SOURCE_MAP.remove(key);
        if (removed != null) {
            super.setTargetDataSources(new ConcurrentHashMap<Object, Object>(DATA_SOURCE_MAP));
            super.afterPropertiesSet();
            dsLogger.info("Successfully removed DataSource with key: {}", (Object)key);
            return true;
        }
        dsLogger.warn("DataSource with key '{}' does not exist", (Object)key);
        return false;
    }

    public Map<Object, Object> getDataSourceMap() {
        return Collections.unmodifiableMap(DATA_SOURCE_MAP);
    }

    public Set<Object> getDataSourceKeys() {
        return Collections.unmodifiableSet(DATA_SOURCE_MAP.keySet());
    }

    public static boolean isExist(Object key) {
        return key != null && DATA_SOURCE_MAP.containsKey(key);
    }

    public static int getDataSourceCount() {
        return DATA_SOURCE_MAP.size();
    }

    public static void setDefaultDataSourceKey(String key) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            defaultDataSourceKey = key;
            dsLogger.info("Set default DataSource key to: {}", (Object)key);
        }
    }

    public static String getDefaultDataSourceKey() {
        return defaultDataSourceKey;
    }

    public boolean checkDataSourceHealth(String key) {
        Object dataSourceObj = DATA_SOURCE_MAP.get(key);
        if (!(dataSourceObj instanceof DataSource)) {
            return false;
        }
        DataSource dataSource = (DataSource)dataSourceObj;
        try {
            dataSource.getConnection().close();
            dsLogger.debug("DataSource '{}' health check passed", (Object)key);
            return true;
        }
        catch (SQLException e) {
            dsLogger.error("DataSource '{}' health check failed", (Object)key, (Object)e);
            return false;
        }
    }
}

