/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider.base;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.entity.JpaPage;
import org.dromara.mybatis.jpa.entity.JpaPageSqlCache;
import org.dromara.mybatis.jpa.util.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchCountProvider<T extends JpaEntity> {
    static final Logger logger = LoggerFactory.getLogger(FetchCountProvider.class);
    public static final Cache<String, JpaPageSqlCache> PAGE_BOUNDSQL_CACHE = Caffeine.newBuilder().expireAfterWrite(300L, TimeUnit.SECONDS).build();

    public String executeCount(JpaPage page) {
        StringBuilder sql = new StringBuilder();
        JpaPageSqlCache pageSqlCache = this.getPageSqlCache(page.getPageSelectId());
        if (pageSqlCache != null) {
            String selectSql = StrUtils.lineBreakToBlank(pageSqlCache.getSql());
            BoundSql boundSql = pageSqlCache.getBoundSql();
            logger.trace("Count original SQL  :\n{}", (Object)selectSql);
            sql.append("select count(1) countrows_ ");
            StringBuilder countSql = new StringBuilder();
            if (boundSql.getParameterMappings() == null || boundSql.getParameterMappings().isEmpty()) {
                countSql.append(selectSql);
            } else {
                for (ParameterMapping parameterMapping : boundSql.getParameterMappings()) {
                    countSql.append(selectSql.substring(0, selectSql.indexOf("?")));
                    countSql.append("#{").append(parameterMapping.getProperty()).append("}");
                    selectSql = selectSql.substring(selectSql.indexOf("?") + 1);
                }
                countSql.append(selectSql);
            }
            String countSqlLowerCase = countSql.toString().toLowerCase().replace("\n", " ");
            logger.trace("Count SQL LowerCase  :\n{}", (Object)countSqlLowerCase);
            if (countSqlLowerCase.indexOf("distinct ") > -1 || countSqlLowerCase.indexOf(" group by ") > -1 || countSqlLowerCase.indexOf(" having ") > -1 || countSqlLowerCase.indexOf(" from ") != countSqlLowerCase.lastIndexOf(" from ")) {
                logger.trace("Count SQL Complex ");
                sql.append("from").append(" (").append((CharSequence)countSql).append(" ) count_table_");
            } else {
                int fromIndex = countSqlLowerCase.indexOf(" from ");
                int orderByIndex = countSqlLowerCase.indexOf(" order by ");
                logger.trace("Count SQL from Index {} , order by {}", (Object)fromIndex, (Object)orderByIndex);
                if (orderByIndex > -1) {
                    sql.append(countSql.substring(fromIndex, orderByIndex));
                } else {
                    sql.append(countSql.substring(fromIndex));
                }
            }
            logger.trace("Count SQL : \n{}", (Object)sql);
        }
        return sql.toString();
    }

    private JpaPageSqlCache getPageSqlCache(String selectId) {
        JpaPageSqlCache cache = (JpaPageSqlCache)PAGE_BOUNDSQL_CACHE.getIfPresent((Object)selectId);
        PAGE_BOUNDSQL_CACHE.invalidate((Object)selectId);
        return cache;
    }
}

